/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany.B;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1XMTest1() throws Exception {
        this.logTrace("Begin detach1XMTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("Persist Instance");
            this.logTrace("Call contains to determined if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                this.logTrace("entity is not detached, cannot proceed with test.");
                pass = false;
            } else {
                try {
                    this.logTrace("Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("IllegalArgumentException thrown trying to persist a detached entity", iae);
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    this.logTrace("entityExistsException thrown trying to persist a detached entity", eee);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logTrace("or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach1XMTest2() throws Exception {
        this.logTrace("Begin detach1XMTest2");
        boolean pass = false;
        try {
            B b1 = new B("1", "b1", 2);
            B b2 = new B("2", "b2", 2);
            B b3 = new B("3", "b3", 2);
            B b4 = new B("4", "b4", 2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.clearCache();
            this.logTrace("Begin Transaction and make sure instance is detached prior to remove");
            this.getEntityTransaction().begin();
            if (!this.getEntityManager().contains((Object)aRef) && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    this.logTrace("aref is detached, Try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("IllegalArgumentException thrown trying to remove a detached entity", iae);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logTrace("or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception caught trying to  remove entity instance :" + fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1XMTest2 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private void dumpCollectionDataB(Collection c) {
        this.logTrace("collection Data");
        this.logTrace("---------------");
        this.logTrace("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            this.logTrace("- Element #" + elem++);
            this.logTrace("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

