/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;

public class Client1
extends Util {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void createQuery() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            pass = true;
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQuery Test  failed");
        }
    }

    public void createQuery2() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            pass = true;
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQuery2 Test  failed");
        }
    }

    public void createTuple() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            this.logTrace("Obtained Non-null Criteria Query Tuple");
            pass = true;
        } else {
            this.logErr("Failed to get Non-null Criteria Query Tuple");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createTuple Test  failed");
        }
    }

    public void tupleSelectionArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                this.logTrace("Obtained Non-null Criteria Query");
                Root cust = cquery.from(Customer.class);
                Selection[] s = new Selection[]{cust.get("id"), cust.get("name")};
                this.logMsg("Testing tuple");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.tuple(s)});
                    this.logErr("Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass1 = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
                this.logMsg("Testing array");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.array(s)});
                    this.logErr("Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass2 = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("tupleSelectionArrayIllegalArgumentExceptionTest failed");
        }
    }

    public void literalIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            cbuilder.literal(null);
            this.logErr("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception:", e);
        }
        if (!pass) {
            throw new Exception("literalIllegalArgumentExceptionTest failed");
        }
    }

    public void trimspecTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<CriteriaBuilder.Trimspec> expected = new ArrayList<CriteriaBuilder.Trimspec>();
        expected.add(CriteriaBuilder.Trimspec.BOTH);
        expected.add(CriteriaBuilder.Trimspec.LEADING);
        expected.add(CriteriaBuilder.Trimspec.TRAILING);
        try {
            CriteriaBuilder.Trimspec[] ts = CriteriaBuilder.Trimspec.values();
            if (ts.length == 3) {
                for (CriteriaBuilder.Trimspec tspec : ts) {
                    pass1 = true;
                    if (expected.contains(tspec)) {
                        this.logMsg("Testing valueOf:" + tspec);
                        CriteriaBuilder.Trimspec.valueOf((String)tspec.toString());
                        continue;
                    }
                    pass2 = false;
                    this.logErr("values() returned incorrect value:" + tspec);
                }
            } else {
                this.logErr("Expected number of values:3, actual:" + ts.length);
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("trimspecTest failed");
        }
    }

    public void createCriteriaDeleteTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
            if (cd != null) {
                this.logTrace("Obtained Non-null CriteriaDelete");
                pass = true;
            } else {
                this.logErr("Failed to get Non-null CriteriaDelete");
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception", ex);
        }
        if (!pass) {
            throw new Exception("createCriteriaDeleteTest test failed");
        }
    }

    public void createCriteriaUpdateTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
            if (cd != null) {
                this.logTrace("Obtained Non-null CriteriaUpdate");
                pass = true;
            } else {
                this.logErr("Failed to get Non-null CriteriaUpdate");
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception", ex);
        }
        if (!pass) {
            throw new Exception("createCriteriaUpdateTest test failed");
        }
    }

    public void coalesceTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaBuilder.Coalesce col = cbuilder.coalesce();
        if (col != null) {
            this.logTrace("Obtained Non-null Coalesce");
            pass = true;
        } else {
            this.logErr("Failed to get Non-null Coalesce");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("coalesceTest failed");
        }
    }
}

