/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptiontests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.TransactionRolledBackException;
import java.util.Properties;

public class ExceptionTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptiontests.ExceptionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        ExceptionTests theTests = new ExceptionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    public void cleanup() throws Exception {
    }

    public void transactionRolledBackExceptionTest1() throws Exception {
        try {
            String errorCode = "Serious";
            String cause = "Rollback operation not allowed.";
            TransactionRolledBackException exceptionToTest = new TransactionRolledBackException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("TransactionRolledBackExceptionTest1 Failed: ");
        }
    }

    public void transactionRolledBackExceptionTest2() throws Exception {
        try {
            TransactionRolledBackException exceptionToTest = new TransactionRolledBackException("Rollback operation not allowed.");
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("TransactionRolledBackExceptionTest2 Failed: ");
        }
    }

    public void testTransactionInProgressException1() throws Exception {
        try {
            String errorCode = "Warning";
            String cause = "Transaction is still in progress.";
            TransactionInProgressException exceptionToTest = new TransactionInProgressException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("TransactionInProgressExceptionTest1 Failed: ");
        }
    }

    public void testTransactionInProgressException2() throws Exception {
        try {
            TransactionInProgressException exceptionToTest = new TransactionInProgressException("Transaction is still in progress.");
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressException transactionInProgressException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("TransactionInProgressExceptionTest2 Failed: ");
        }
    }

    public void testResourceAllocationException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot get the resource, not enough heap space.";
            ResourceAllocationException exceptionToTest = new ResourceAllocationException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("ResourceAllocationException1 Failed: ");
        }
    }

    public void resourceAllocationExceptionTest2() throws Exception {
        try {
            ResourceAllocationException exceptionToTest = new ResourceAllocationException("Cannot get the resource, not enough heap space.");
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationException resourceAllocationException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("ResourceAllocationException2 Failed: ");
        }
    }

    public void testMessageNotWriteableException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Message just received";
            MessageNotWriteableException exceptionToTest = new MessageNotWriteableException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageNotWriteableExceptionTest1 Failed: ");
        }
    }

    public void testMessageNotWriteableException2() throws Exception {
        try {
            MessageNotWriteableException exceptionToTest = new MessageNotWriteableException("Message just received");
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableException messageNotWriteableException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageNotWriteableExceptionTest2 Failed: ");
        }
    }

    public void testMessageNotReadableException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Message is empty";
            MessageNotReadableException exceptionToTest = new MessageNotReadableException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotReadableException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageNotReadableExceptionTest1 Failed: ");
        }
    }

    public void testMessageNotReadableException2() throws Exception {
        try {
            MessageNotReadableException exceptionToTest = new MessageNotReadableException("Message is empty");
            try {
                throw exceptionToTest;
            }
            catch (MessageNotReadableException messageNotReadableException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageNotReadableExceptionTest2 Failed: ");
        }
    }

    public void testMessageFormatException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot convert from int to char";
            MessageFormatException exceptionToTest = new MessageFormatException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageFormatExceptionTest1 Failed: ");
        }
    }

    public void testMessageFormatException2() throws Exception {
        try {
            MessageFormatException exceptionToTest = new MessageFormatException("Cannot convert from int to char");
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatException messageFormatException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageFormatExceptionTest2 Failed: ");
        }
    }

    public void testMessageEOFException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "It is a byte, not an int.";
            MessageEOFException exceptionToTest = new MessageEOFException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageEOFException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageEOFExceptionTest1 Failed: ");
        }
    }

    public void testMessageEOFException2() throws Exception {
        try {
            MessageEOFException exceptionToTest = new MessageEOFException("It is a byte, not an int.");
            try {
                throw exceptionToTest;
            }
            catch (MessageEOFException messageEOFException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MessageEOFExceptionTest2 Failed: ");
        }
    }

    public void testJMSSecurityException1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Cannot find the user.";
            JMSSecurityException exceptionToTest = new JMSSecurityException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("JMSSecurityExceptionTest1 Failed: ");
        }
    }

    public void testJMSSecurityException2() throws Exception {
        try {
            JMSSecurityException exceptionToTest = new JMSSecurityException("Cannot find the user.");
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityException jMSSecurityException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("JMSSecurityExceptionTest2 Failed: ");
        }
    }

    public void testJMSException1() throws Exception {
        try {
            String errorCode = "Warning";
            String cause = "Not a JMS operation";
            JMSException exceptionToTest = new JMSException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("JMSExceptionTest1 Failed: ");
        }
    }

    public void testJMSException2() throws Exception {
        try {
            String cause = "Not a JMS operation";
            String cause1 = "Deprecated since v1.1";
            JMSException exceptionToTest = new JMSException(cause);
            JMSException exceptionToTest1 = new JMSException(cause1);
            exceptionToTest.setLinkedException((Exception)((Object)exceptionToTest1));
            if (!exceptionToTest.getLinkedException().getMessage().equals(exceptionToTest1.getMessage())) {
                throw new Exception("Linked Exception does not return correct message " + exceptionToTest.getLinkedException().getMessage());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("JMSExceptionTest2 Failed: ");
        }
    }

    public void invalidSelectorExceptionTest1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "unknown variable";
            InvalidSelectorException exceptionToTest = new InvalidSelectorException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidSelectorExceptionTest1 Failed: ");
        }
    }

    public void invalidSelectorExceptionTest2() throws Exception {
        try {
            InvalidSelectorException exceptionToTest = new InvalidSelectorException("unknown variable");
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorException invalidSelectorException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidSelectorExceptionTest2 Failed: ");
        }
    }

    public void invalidDestinationExceptionTest1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Destination is Null";
            InvalidDestinationException exceptionToTest = new InvalidDestinationException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidDestinationExceptionTest1 Failed: ");
        }
    }

    public void invalidDestinationExceptionTest2() throws Exception {
        try {
            InvalidDestinationException exceptionToTest = new InvalidDestinationException("Destination is Null");
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationException invalidDestinationException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidDestinationExceptionTest2 Failed: ");
        }
    }

    public void invalidClientIDExceptionTest1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "Duplicate Client ID";
            InvalidClientIDException exceptionToTest = new InvalidClientIDException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidClientIDExceptionTest1 Failed: ");
        }
    }

    public void invalidClientIDExceptionTest2() throws Exception {
        try {
            InvalidClientIDException exceptionToTest = new InvalidClientIDException("Duplicate Client ID");
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDException invalidClientIDException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidClientIDExceptionTest2 Failed: ");
        }
    }

    public void illegalStateExceptionTest1() throws Exception {
        try {
            String errorCode = "Urgent";
            String cause = "The operation is intended for Queue Configuration only.";
            IllegalStateException exceptionToTest = new IllegalStateException(cause, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    throw new Exception("Incorrect ErrorCode " + exceptionToTest.getErrorCode(), e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("IllegalStateExceptionTest1 Failed: ");
        }
    }

    public void illegalStateExceptionTest2() throws Exception {
        try {
            IllegalStateException exceptionToTest = new IllegalStateException("The operation is intended for Queue Configuration only.");
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Failed to construct IllegalStateException: ");
        }
    }
}

