/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedTopicConnection;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedTopicConnectionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedTopicConnection.ClosedTopicConnectionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicConnectionTests theTests = new ClosedTopicConnectionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseConnection(int type, String user, String password) throws Exception {
        if (type == 1 || type == 3) {
            tool = new JmsTool(type, user, password, this.mode);
            tool.getDefaultTopicConnection().start();
            this.logTrace("Closing queue Connection");
            tool.getDefaultTopicConnection().close();
        }
        this.logTrace("Connection closed");
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.logTrace("Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (tool != null) {
                this.logTrace("Cleanup: Closing Topic and Topic Connections");
                tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedTopicConnectionGetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            this.logTrace("Try to call getExceptionListener");
            try {
                ExceptionListener foo = tool.getDefaultTopicConnection().getExceptionListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetExceptionListenerTest", e);
        }
    }

    public void closedTopicConnectionSetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            this.logTrace("Try to call setClientID");
            try {
                tool.getDefaultTopicConnection().setClientID("foo");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetClientIDTest", e);
        }
    }

    public void closedTopicConnectionSetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            this.logTrace("Try to call setExceptionListener");
            try {
                ExceptionListener foo = new ExceptionListener(){

                    public void onException(JMSException jmsE) {
                    }
                };
                tool.getDefaultTopicConnection().setExceptionListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetExceptionListenerTest", e);
        }
    }

    public void closedTopicConnectionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            this.logTrace("Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultTopicSubscriber().getMessageListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMessageListenerTest", e);
        }
    }

    public void closedTopicConnectionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            this.logTrace("Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultTopicSubscriber().setMessageListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetMessageListenerTest", e);
        }
    }

    public void closedTopicConnectionStopTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            TestUtil.logTrace((String)"Try to call stop");
            try {
                tool.getDefaultTopicConnection().stop();
                TestUtil.logTrace((String)"Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: wrong exception: " + e.getClass().getName() + " was returned"));
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionStopTest", e);
        }
    }
}

