/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.jndi.earjar;

import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.basic.common.GlobalJNDITest;
import com.sun.ts.tests.ejb30.lite.basic.stateless.BasicBean;
import com.sun.ts.tests.ejb30.misc.jndi.earjar.TestIF;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import javax.naming.Context;

@Singleton
public class TestBean
implements TestIF {
    @Resource(lookup="java:module/ModuleName")
    private String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private String appNameInjected;
    @EJB(lookup="java:global/misc_jndi_earjar/misc_jndi_earjar_ejb/BasicBean!com.sun.ts.tests.ejb30.lite.basic.stateless.BasicBean")
    private BasicBean basicBean;

    @Override
    public String globalJNDI(String appName, String moduleName) {
        return this.basicBean.globalJNDI(appName, moduleName);
    }

    @Override
    public String appJNDI(String moduleName) {
        return this.basicBean.appJNDI(moduleName);
    }

    @Override
    public String moduleJNDI() {
        return this.basicBean.moduleJNDI();
    }

    @Override
    public int add(int a, int b) {
        return a + b;
    }

    @Override
    public String globalJNDIHelloEJB(String appName, String moduleName, String beanName, Class<?> intf) {
        String lookupName = GlobalJNDITest.getGlobalJNDIName(appName, moduleName, beanName, intf);
        HelloRemoteIF h = (HelloRemoteIF)ServiceLocator.lookupNoTry(lookupName, new Context[0]);
        return h.getMessage().toString();
    }

    @Override
    public String appNameModuleName() {
        StringBuilder sb = new StringBuilder();
        String lookup = "java:module/ModuleName";
        String expected = "misc_jndi_earjar_ejb";
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, this.moduleNameInjected, sb);
        lookup = "java:app/AppName";
        expected = "misc_jndi_earjar";
        actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, this.appNameInjected, sb);
        return sb.toString();
    }
}

