/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.equals.descriptor;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.ejb30.common.equals.Comparator;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.NamingException;

public class Client
extends EETest {
    protected static final boolean CLIENT_LOG_IF_OK = true;
    protected Properties props;

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    public void cleanup() throws Exception {
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void selfEqualsLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public void otherNotEqualsLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cartOther = ServiceLocator.lookupByShortName("cartOther");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCartOther = ServiceLocator.lookupByShortName("shoppingCartOther");
            Comparator.compare(cart, cartOther, false, true);
            Comparator.compare(shoppingCart, shoppingCartOther, false, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public void differentInterfaceNotEqualLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }

    public void differentBeanSameInterfaceNotEqualLookup() throws Exception {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cart2 = ServiceLocator.lookupByShortName("cart2");
            Comparator.compare(cart, cart2, false, true);
            TLogger.log("cart.hashCode =" + cart.hashCode());
            TLogger.log("cart2.hashCode=" + cart2.hashCode());
            HashSet<Object> carts = new HashSet<Object>();
            carts.add(cart);
            carts.add(cart2);
            TLogger.log("carts=" + carts);
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCart2 = ServiceLocator.lookupByShortName("shoppingCart2");
            Comparator.compare(shoppingCart, shoppingCart2, false, true);
            TLogger.log("shoppingCart.hashCode =" + shoppingCart.hashCode());
            TLogger.log("shoppingCart2.hashCode=" + shoppingCart2.hashCode());
            HashSet<Object> shoppingCarts = new HashSet<Object>();
            shoppingCarts.add(shoppingCart);
            shoppingCarts.add(shoppingCart2);
            TLogger.log("shoppingCarts=" + shoppingCarts);
        }
        catch (TestFailedException e) {
            throw new Exception(e);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
    }
}

