/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.txpropagationtest;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jta.ee.txpropagationtest.DBSupport;
import com.sun.ts.tests.jta.ee.txpropagationtest.TxBean;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class Client
extends ServiceEETest
implements Serializable {
    private static final String txRef = "java:comp/env/ejb/MyEjbReference";
    private TSNamingContext nctx;
    private Properties testProps;
    private TxBean beanRef;
    private DBSupport db;
    private UserTransaction ut;
    private String tName1;
    private String tName2;
    private Integer tSize;
    private Integer fromKey1;
    private Integer fromKey2;
    private Integer toKey2;

    public static void main(String[] args) {
        Client client = new Client();
        Status s = client.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.testProps = p;
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Setup tests");
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup TxBean: java:comp/env/ejb/MyEjbReference");
            this.beanRef = (TxBean)this.nctx.lookup(txRef, TxBean.class);
            TestUtil.logMsg((String)"Lookup java:comp/UserTransaction");
            this.ut = (UserTransaction)this.nctx.lookup("java:comp/UserTransaction");
            TestUtil.logMsg((String)"Create DBSupport class");
            this.db = new DBSupport(this.testProps);
            TestUtil.logMsg((String)"Lookup environment variables");
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"JTA_Tab1_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
            this.tName2 = TestUtil.getTableName((String)TestUtil.getProperty((String)"JTA_Tab2_Delete"));
            TestUtil.logTrace((String)("tName2: " + this.tName2));
            this.tSize = (Integer)this.nctx.lookup("java:comp/env/size");
            TestUtil.logTrace((String)("tSize: " + this.tSize));
            this.fromKey1 = (Integer)this.nctx.lookup("java:comp/env/fromKey1");
            TestUtil.logTrace((String)("fromKey1: " + this.fromKey1));
            this.fromKey2 = (Integer)this.nctx.lookup("java:comp/env/fromKey2");
            TestUtil.logTrace((String)("fromKey2: " + this.fromKey2));
            this.toKey2 = (Integer)this.nctx.lookup("java:comp/env/toKey2");
            TestUtil.logTrace((String)("toKey2: " + this.toKey2));
            TestUtil.logMsg((String)"Initialize java:comp/env/ejb/MyEjbReference");
            this.beanRef.initialize(p);
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in setup: ", (Throwable)e);
            throw new Exception("setup failed", e);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup ok");
    }

    public void test1() throws Exception {
        String testname = "test1";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
        TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            this.beanRef.createData(tName1);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete(tName1, tRng, tRng);
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName1);
            dbResults = this.beanRef.getResults(tName1);
            TestUtil.logMsg((String)"Verifying the test results");
            if (!dbResults.contains(tRng)) {
                b1 = true;
            }
            for (int i = 1; i <= tSize; ++i) {
                if (i == tRng) continue;
                if (dbResults.contains(i)) {
                    b2 = true;
                    continue;
                }
                b2 = false;
                break;
            }
            this.beanRef.dbUnConnect(tName1);
            this.ut.commit();
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName1);
                this.beanRef.destroyData(tName1);
                this.beanRef.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test2() throws Exception {
        String testname = "test2";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
        TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName2 = this.tName2;
        int tSize = this.tSize;
        int tSizeOrig = this.tSize;
        int tRngFrom = this.fromKey2;
        int tRngTo = this.toKey2;
        try {
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.beanRef.dbConnect(tName2);
            this.beanRef.createData(tName2);
            this.beanRef.dbUnConnect(tName2);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.beanRef.dbConnect(tName2);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete(tName2, tRngFrom, tRngTo);
            this.beanRef.dbUnConnect(tName2);
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.beanRef.dbConnect(tName2);
            dbResults = this.beanRef.getResults(tName2);
            TestUtil.logMsg((String)"Verifying the test results");
            for (int i = 1; i <= tSizeOrig; ++i) {
                if (!dbResults.contains(i)) {
                    b1 = false;
                    break;
                }
                b1 = true;
            }
            for (int j = tSize; j > tSizeOrig; --j) {
                if (dbResults.contains(j)) {
                    b2 = false;
                    break;
                }
                b2 = true;
            }
            this.beanRef.dbUnConnect(tName2);
            this.ut.commit();
            if (b1) {
                TestUtil.logTrace((String)"b1 true");
            }
            if (b2) {
                TestUtil.logTrace((String)"b2 true");
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName2);
                this.beanRef.destroyData(tName2);
                this.beanRef.dbUnConnect(tName2);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test3() throws Exception {
        String testname = "test3";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a commit, and checking TxStatus");
        TestUtil.logMsg((String)"Database access is performed from TxBean EJB");
        boolean testResult = false;
        boolean b3 = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName2 = this.tName2;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            int txStatus1 = this.ut.getStatus();
            TestUtil.logTrace((String)("Tx Status: " + txStatus1));
            TestUtil.logMsg((String)"BEGIN transaction");
            this.ut.begin();
            int txStatus2 = this.ut.getStatus();
            TestUtil.logMsg((String)("Tx Status: " + txStatus2));
            TestUtil.logTrace((String)"Calling dbConnect method");
            this.beanRef.dbConnect(tName2);
            this.beanRef.createData(tName2);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            if (this.beanRef.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.beanRef.delete(tName2, tRng, tRng);
            this.beanRef.dbUnConnect(tName2);
            TestUtil.logMsg((String)"COMMIT transaction");
            this.ut.commit();
            int txStatus3 = this.ut.getStatus();
            TestUtil.logMsg((String)("Tx Status: " + txStatus3));
            TestUtil.logMsg((String)"Verifying the test results");
            if (txStatus1 == 6) {
                b1 = true;
            }
            if (txStatus2 == 0) {
                b2 = true;
            }
            if (txStatus3 == 6) {
                b3 = true;
            }
            if (b1 && b2 && b3) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.beanRef.dbConnect(tName2);
                this.beanRef.destroyData(tName2);
                this.beanRef.dbUnConnect(tName2);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test4() throws Exception {
        String testname = "test4";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a commit to a single table");
        TestUtil.logMsg((String)"Database access is performed from Servlet, EJB or JSP");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName1 = this.tName1;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.db.dbConnect(tName1);
            this.db.createData(tName1);
            this.db.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.db.dbConnect(tName1);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.db.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            if (this.db.insert(tName1, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.db.delete(tName1, tRng, tRng);
            this.db.dbUnConnect(tName1);
            this.ut.commit();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.db.dbConnect(tName1);
            dbResults = this.db.getResults(tName1);
            TestUtil.logMsg((String)"Verifying the test results");
            if (!dbResults.contains(tRng)) {
                b1 = true;
            }
            for (int i = 1; i <= tSize; ++i) {
                if (i == tRng) continue;
                if (dbResults.contains(i)) {
                    b2 = true;
                    continue;
                }
                b2 = false;
                break;
            }
            this.db.dbUnConnect(tName1);
            this.ut.commit();
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.db.dbConnect(tName1);
                this.db.destroyData(tName1);
                this.db.dbUnConnect(tName1);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test5() throws Exception {
        String testname = "test5";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a rollback to a single table");
        TestUtil.logMsg((String)"Database access is performed Servlet, EJB or JSP");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName2 = this.tName2;
        int tSize = this.tSize;
        int tSizeOrig = this.tSize;
        int tRngFrom = this.fromKey2;
        int tRngTo = this.toKey2;
        try {
            TestUtil.logMsg((String)"Creating the table");
            this.ut.begin();
            this.db.dbConnect(tName2);
            this.db.createData(tName2);
            this.db.dbUnConnect(tName2);
            this.ut.commit();
            TestUtil.logMsg((String)"Insert and delete some rows");
            this.ut.begin();
            this.db.dbConnect(tName2);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.db.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            if (this.db.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.db.delete(tName2, tRngFrom, tRngTo);
            this.db.dbUnConnect(tName2);
            this.ut.rollback();
            TestUtil.logMsg((String)"Get test results");
            this.ut.begin();
            this.db.dbConnect(tName2);
            dbResults = this.db.getResults(tName2);
            TestUtil.logMsg((String)"Verifying the test results");
            for (int i = 1; i <= tSizeOrig; ++i) {
                if (!dbResults.contains(i)) {
                    b1 = false;
                    break;
                }
                b1 = true;
            }
            for (int j = tSize; j > tSizeOrig; --j) {
                if (dbResults.contains(j)) {
                    b2 = false;
                    break;
                }
                b2 = true;
            }
            this.db.dbUnConnect(tName2);
            this.ut.commit();
            if (b1) {
                TestUtil.logTrace((String)"b1 true");
            }
            if (b2) {
                TestUtil.logTrace((String)"b2 true");
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.db.dbConnect(tName2);
                this.db.destroyData(tName2);
                this.db.dbUnConnect(tName2);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }

    public void test6() throws Exception {
        String testname = "test6";
        TestUtil.logTrace((String)testname);
        TestUtil.logMsg((String)"Transaction propagation from Servlet, EJB or JSP");
        TestUtil.logMsg((String)"Insert/Delete followed by a commit, and checking TxStatus");
        TestUtil.logMsg((String)"Database access is performed from Servlet, EJB or JSP");
        boolean testResult = false;
        boolean b3 = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName2 = this.tName2;
        int tSize = this.tSize;
        int tRng = this.fromKey1;
        try {
            int txStatus1 = this.ut.getStatus();
            TestUtil.logTrace((String)("Tx Status: " + txStatus1));
            TestUtil.logMsg((String)"BEGIN transaction");
            this.ut.begin();
            int txStatus2 = this.ut.getStatus();
            TestUtil.logMsg((String)("Tx Status: " + txStatus2));
            TestUtil.logMsg((String)"Calling dbConnect method");
            this.db.dbConnect(tName2);
            this.db.createData(tName2);
            TestUtil.logMsg((String)"Inserting 2 new rows");
            if (this.db.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            if (this.db.insert(tName2, tSize + 1)) {
                ++tSize;
            }
            TestUtil.logMsg((String)"Deleting a row");
            this.db.delete(tName2, tRng, tRng);
            this.db.dbUnConnect(tName2);
            TestUtil.logMsg((String)"COMMIT transaction");
            this.ut.commit();
            int txStatus3 = this.ut.getStatus();
            TestUtil.logMsg((String)("Tx Status: " + txStatus3));
            TestUtil.logMsg((String)"Verifying the test results");
            if (txStatus1 == 6) {
                b1 = true;
            }
            if (txStatus2 == 0) {
                b2 = true;
            }
            if (txStatus3 == 6) {
                b3 = true;
            }
            if (b1 && b2 && b3) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testname + " failed", e);
        }
        finally {
            try {
                this.ut.begin();
                this.db.dbConnect(tName2);
                this.db.destroyData(tName2);
                this.db.dbUnConnect(tName2);
                this.ut.commit();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (!testResult) {
                throw new Exception(testname + " failed");
            }
        }
    }
}

