/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.fmt.i18n.bundle;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_fmt_bundle_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_fmt_bundle_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_fmt_bundle_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundleBasenameNullEmptyTest.jsp")), "positiveBundleBasenameNullEmptyTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundleBasenameTest.jsp")), "positiveBundleBasenameTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundleFallbackLocaleTest.jsp")), "positiveBundleFallbackLocaleTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundleLocaleConfigurationTest.jsp")), "positiveBundleLocaleConfigurationTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundleLocalizationScopeTest.jsp")), "positiveBundleLocalizationScopeTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveBundlePrefixTest.jsp")), "positiveBundlePrefixTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveBundleBasenameTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundleBasenameTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundleBasenameTest");
        TEST_PROPS.setProperty("request", "positiveBundleBasenameTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en");
        this.invoke();
    }

    @Test
    public void positiveBundlePrefixTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundlePrefixTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundlePrefixTest");
        TEST_PROPS.setProperty("request", "positiveBundlePrefixTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en");
        this.invoke();
    }

    @Test
    public void positiveBundleBasenameNullEmptyTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundleBasenameNullEmptyTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundleBasenameNullEmptyTest");
        TEST_PROPS.setProperty("request", "positiveBundleBasenameNullEmptyTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en");
        this.invoke();
    }

    @Test
    public void positiveBundleLocalizationScopeTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundleLocalizationScopeTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundleLocalizationScopeTest");
        TEST_PROPS.setProperty("request", "positiveBundleLocalizationScopeTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: en");
        this.invoke();
    }

    @Test
    public void positiveBundleLocaleConfigurationTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundleLocaleConfigurationTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundleLocaleConfigurationTest");
        TEST_PROPS.setProperty("request", "positiveBundleLocaleConfigurationTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja");
        this.invoke();
    }

    @Test
    public void positiveBundleFallbackLocaleTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveBundleFallbackLocaleTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "positiveBundleFallbackLocaleTest");
        TEST_PROPS.setProperty("request", "positiveBundleFallbackLocaleTest.jsp");
        TEST_PROPS.setProperty("request_headers", "Accept-Language: ja");
        this.invoke();
    }
}

