/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.usertransaction.settransactiontimeout;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jta.ee.common.Transact;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;

public class UserSetTransactionTimeoutClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jta.ee.usertransaction.settransactiontimeout";
    private UserTransaction userTransaction = null;

    public void setup(String[] args, Properties p) throws Exception {
        try {
            Transact.init();
            this.logTrace("Test environment initialized");
            this.userTransaction = (UserTransaction)Transact.nctx.lookup("java:comp/UserTransaction");
            this.logMsg("User Transaction object is Obtained");
            if (this.userTransaction == null) {
                this.logErr("Unable to get User Transaction Instance : Could not proceed with tests");
                throw new Exception("couldnt proceed further");
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Exception exception) {
            this.logErr("Setup Failed!");
            this.logTrace("Unable to get User Transaction Instance : Could not proceed with tests");
            throw new Exception("Setup Failed", exception);
        }
    }

    public static void main(String[] args) {
        UserSetTransactionTimeoutClient userSetTransTout = new UserSetTransactionTimeoutClient();
        Status s = userSetTransTout.run(args, System.out, System.err);
        s.exit();
    }

    public void testUserSetTransactionTimeout001() throws Exception {
        block6: {
            boolean pass = false;
            try {
                this.userTransaction.setTransactionTimeout(10);
                this.userTransaction.begin();
                this.logMsg("UserTransaction Started");
                if (this.userTransaction.getStatus() != 0) break block6;
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                Thread.currentThread();
                Thread.sleep(30000L);
                try {
                    this.userTransaction.commit();
                }
                catch (IllegalStateException ise) {
                    this.logMsg("Exception caught as expected");
                    pass = true;
                }
                catch (RollbackException rbe) {
                    this.logMsg("RollbackException caught as expected");
                    pass = true;
                }
                if (!pass) {
                    throw new Exception("Exception was not thrown as Expected");
                }
            }
            catch (Exception exception) {
                this.logErr("Exception " + exception.toString() + " was caught");
                throw new Exception("Exception was not thrown as Expected in commit()", exception);
            }
        }
    }

    public void testUserSetTransactionTimeout002() throws Exception {
        try {
            this.userTransaction.setTransactionTimeout(10);
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                Thread.currentThread();
                Thread.sleep(5000L);
                this.userTransaction.commit();
            }
            if (this.userTransaction.getStatus() != 6) {
                throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("status is STATUS_NO_TRANSACTION");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void cleanup() throws Exception {
        block8: {
            try {
                if (this.userTransaction.getStatus() == 0) {
                    Transact.free();
                    try {
                        this.userTransaction.rollback();
                    }
                    catch (Exception exception) {
                        throw new Exception(exception.getCause());
                    }
                    for (int retries = 1; this.userTransaction.getStatus() != 6 && retries <= 5; ++retries) {
                        this.logMsg("cleanup(): retry # " + retries);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception(e.getCause());
                        }
                    }
                    this.logMsg("Cleanup ok;");
                    break block8;
                }
                this.logMsg("CleanUp not required as Transaction is not in Active state.");
            }
            catch (Exception exception) {
                this.logErr("Cleanup Failed", exception);
                this.logTrace("Could not clean the environment");
            }
        }
    }
}

