/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.lock.query;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.lock.query.Department;
import ee.jakarta.tck.persistence.core.lock.query.Employee;
import ee.jakarta.tck.persistence.core.lock.query.Insurance;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TransactionRequiredException;
import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private final Date d1 = this.getSQLDate("2000-02-14");

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.logTrace("Create Test Data");
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResultListTest1() throws Exception {
        Object employeeFound;
        List c;
        LockModeType lm;
        Query query;
        EntityManager em;
        boolean pass = true;
        this.logTrace("Begin getResultListTest1");
        try {
            this.logTrace("Testing Query version");
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            query = em.createQuery("select e from Employee e where e.id < 10 ");
            lm = query.getLockMode();
            if (lm == null || lm.equals((Object)LockModeType.NONE)) {
                if (lm == null) {
                    this.logTrace("Received null when no LockModeType had been set");
                } else {
                    this.logTrace("Received " + lm.toString() + " when no LockModeType had been specifically set");
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    this.logTrace("Received LockModeType:" + lm.name());
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    this.logTrace("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                } else {
                    this.logErr("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm);
                    pass = false;
                }
                c = query.getResultList();
                for (Employee e : c) {
                    lm = em.getLockMode((Object)e);
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        this.logTrace("Received LockModeType:" + lm.name());
                        continue;
                    }
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        this.logTrace("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                        continue;
                    }
                    this.logErr("LockMoteType for the Employee[" + e.getId() + "] was wrong - Expected:" + LockModeType.PESSIMISTIC_READ.name() + ", Actual:" + lm);
                    pass = false;
                }
                employeeFound = (Employee)this.getEntityManager().find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
                ((Employee)employeeFound).setSalary(90000.0f);
            } else {
                this.logErr("Expected null when no LockModeType had been set, Actual:" + lm);
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
                pass = false;
            }
        }
        this.logTrace("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            query = em.createQuery("select e from Employee e where e.id < 10 ", Employee.class);
            lm = query.getLockMode();
            if (lm == null || lm.equals((Object)LockModeType.NONE)) {
                if (lm == null) {
                    this.logTrace("Received null when no LockModeType had been set");
                } else {
                    this.logTrace("Received " + lm.toString() + " when no LockModeType had been specifically set");
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    this.logTrace("Received LockModeType:" + lm.name());
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    this.logTrace("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                } else {
                    this.logErr("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm);
                    pass = false;
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    this.logTrace("Received LockModeType:" + lm.name());
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    this.logTrace("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                } else {
                    this.logErr("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm);
                    pass = false;
                }
                c = query.getResultList();
                for (Employee e : c) {
                    lm = em.getLockMode((Object)e);
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        this.logTrace("Received LockModeType:" + lm.name());
                        continue;
                    }
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        this.logTrace("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                        continue;
                    }
                    this.logErr("LockMoteType for the Employee[" + e.getId() + "] was wrong - Expected:" + LockModeType.PESSIMISTIC_READ.name() + ", Actual:" + lm);
                    pass = false;
                }
                employeeFound = (Employee)this.getEntityManager().find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
                ((Employee)employeeFound).setSalary(90000.0f);
            } else {
                this.logErr("query.getLockMode() returned a null instead of " + LockModeType.NONE + ", when no LockModeType had been set");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("getResultListTest1 failed");
        }
    }

    public void getLockModeNONSELECTIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Query");
            this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0").getLockMode();
            this.logErr("IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            this.logTrace("Received expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("getLockModeNONSELECTIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        this.logTrace("Begin getLockModeObjectIllegalArgumentExceptionTest");
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Employee e = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            try {
                em.getLockMode((Object)e);
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("getLockModeObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectTransactionRequiredException1Test() throws Exception {
        boolean pass = false;
        int expected = 9;
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Query query = em.createQuery("select e from Employee e where e.id < 10 ");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            List c = query.getResultList();
            this.getEntityTransaction().commit();
            this.logTrace("isActive=" + this.getEntityTransaction().isActive());
            int found = 0;
            for (Employee e : c) {
                try {
                    em.getLockMode((Object)e);
                    this.logErr("Did not get TransactionRequiredException for employee:" + e);
                }
                catch (TransactionRequiredException tre) {
                    ++found;
                }
            }
            if (found == expected) {
                this.logTrace("Got expected number of TransactionRequiredExceptions:" + expected);
                pass = true;
            } else {
                this.logErr("Number of TransactionRequiredException Expected:" + c.size() + ", Actual:" + found);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("getLockModeObjectTransactionRequiredException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectIllegalArgumentException1Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Query query = em.createQuery("select e from Employee e where e.id < 10 ");
            this.logTrace("Setting lock mode to PESSIMISTIC_READ");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            List c = query.getResultList();
            int found = 0;
            for (Employee e : c) {
                try {
                    this.logTrace("Detaching Employee:" + e.getId());
                    em.detach((Object)e);
                    this.logTrace("Calling getLockMode()");
                    em.getLockMode((Object)e);
                }
                catch (IllegalArgumentException iae) {
                    ++found;
                }
            }
            if (found == c.size()) {
                pass = true;
            } else {
                this.logErr("Number of IllegalArgumentException Expected:" + c.size() + ", Actual:" + found);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("getLockModeObjectIllegalArgumentException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockModeIllegalStateException() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Native version");
        try {
            Query nativeQuery = this.getEntityManager().createNativeQuery("Select ID from DEPARTMENT where ID=1");
            nativeQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
            this.logErr("IllegalStateException should have been thrown after setLockMode");
        }
        catch (IllegalStateException e) {
            this.logTrace("Got IllegalStateException as expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        this.logMsg("Testing Query version");
        try {
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0");
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            this.logErr("IllegalStateException should have been thrown");
        }
        catch (IllegalStateException e) {
            this.logTrace("Got IllegalStateException as expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setLockModeIllegalStateException failed");
        }
    }

    public void getResultListTest2() throws Exception {
        Query query;
        boolean pass = true;
        this.logTrace("Testing Query version");
        try {
            this.logTrace("Invoking query for getResultListTest2");
            query = this.getEntityManager().createQuery("select e.department from Employee e where e.id < 10 order by e.department.id").setFirstResult(3);
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getResultList();
            this.logErr("TransactionRequiredException not thrown");
            pass = false;
        }
        catch (TransactionRequiredException e) {
            this.logTrace("Got TransactionRequiredException as expected");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        this.logTrace("Testing TypedQuery version");
        try {
            this.logTrace("Invoking query for getResultListTest2");
            query = this.getEntityManager().createQuery("select e.department from Employee e where e.id < 10 order by e.department.id", Department.class).setFirstResult(3);
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getResultList();
            this.logErr("TransactionRequiredException not thrown");
            pass = false;
        }
        catch (TransactionRequiredException e) {
            this.logTrace("Got TransactionRequiredException as expected");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getResultListTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTest() throws Exception {
        boolean pass = false;
        this.logTrace("Begin getSingleResultTest");
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select d.name from Department d where d.id = 1");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getSingleResult();
            Department departmentFound = (Department)this.getEntityManager().find(Department.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            departmentFound.setName("NewDepartment");
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("getSingleResultTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        Employee[] empRef = new Employee[20];
        Department[] deptRef = new Department[10];
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 Departments");
            deptRef[0] = new Department(1, "Engineering");
            deptRef[1] = new Department(2, "Marketing");
            deptRef[2] = new Department(3, "Sales");
            deptRef[3] = new Department(4, "Accounting");
            deptRef[4] = new Department(5, "Training");
            this.logTrace("Start to persist departments ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.doFlush();
                this.logTrace("persisted department " + department);
            }
            this.logTrace("Create 3 Insurance Carriers");
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            this.logTrace("Start to persist insurance ");
            for (Serializable serializable : insRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.doFlush();
                this.logTrace("persisted insurance " + (Insurance)serializable);
            }
            this.logTrace("Create 20 employees");
            empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            empRef[0].setDepartment(deptRef[0]);
            empRef[0].setInsurance(insRef[0]);
            empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            empRef[1].setDepartment(deptRef[1]);
            empRef[1].setInsurance(insRef[1]);
            empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            empRef[2].setDepartment(deptRef[2]);
            empRef[2].setInsurance(insRef[2]);
            empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            empRef[3].setDepartment(deptRef[3]);
            empRef[3].setInsurance(insRef[0]);
            empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            empRef[4].setDepartment(deptRef[4]);
            empRef[4].setInsurance(insRef[1]);
            empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            empRef[5].setDepartment(deptRef[0]);
            empRef[5].setInsurance(insRef[2]);
            empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            empRef[6].setDepartment(deptRef[1]);
            empRef[6].setInsurance(insRef[0]);
            empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            empRef[7].setDepartment(deptRef[2]);
            empRef[7].setInsurance(insRef[1]);
            empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            empRef[8].setDepartment(deptRef[3]);
            empRef[8].setInsurance(insRef[2]);
            empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            empRef[9].setDepartment(deptRef[4]);
            empRef[9].setInsurance(insRef[0]);
            empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            empRef[10].setDepartment(deptRef[0]);
            empRef[10].setInsurance(insRef[1]);
            empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            empRef[11].setDepartment(deptRef[1]);
            empRef[11].setInsurance(insRef[2]);
            empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            empRef[12].setDepartment(deptRef[2]);
            empRef[12].setInsurance(insRef[0]);
            empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            empRef[13].setDepartment(deptRef[3]);
            empRef[13].setInsurance(insRef[1]);
            empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            empRef[14].setDepartment(deptRef[4]);
            empRef[14].setInsurance(insRef[2]);
            empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            empRef[15].setDepartment(deptRef[0]);
            empRef[15].setInsurance(insRef[0]);
            empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            empRef[16].setDepartment(deptRef[1]);
            empRef[16].setInsurance(insRef[1]);
            empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            empRef[17].setDepartment(deptRef[2]);
            empRef[17].setInsurance(insRef[2]);
            empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            empRef[18].setDepartment(deptRef[3]);
            empRef[18].setInsurance(insRef[0]);
            empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            empRef[19].setDepartment(deptRef[4]);
            empRef[19].setInsurance(insRef[1]);
            this.logTrace("Start to persist employees ");
            for (Serializable serializable : empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.doFlush();
                this.logTrace("persisted employee " + (Employee)serializable);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in createTestData:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in createTestData while rolling back TX:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

