/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.ScheduleAttributeType;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;

public final class TimerUtil {
    private TimerUtil() {
    }

    public static void cancelAllTimers(TimerService timerService, boolean failOnError) {
        Collection timers = timerService.getTimers();
        for (Timer timer : timers) {
            try {
                timer.cancel();
            }
            catch (RuntimeException e) {
                if (failOnError) {
                    throw e;
                }
                Helper.getLogger().warning(e.toString());
            }
        }
    }

    public static void cancelTimer(TimerService timerService, String name) {
        Collection timers = timerService.getTimers();
        for (Timer timer : timers) {
            TimerInfo info = (TimerInfo)timer.getInfo();
            if (!info.getTestName().equals(name)) continue;
            timer.cancel();
        }
    }

    public static int countTimers(TimerService timerService) {
        return timerService.getTimers().size();
    }

    public static int countTimers(Collection<Timer> timers, String testName) {
        int result = 0;
        for (Timer t : timers) {
            TimerInfo info = (TimerInfo)t.getInfo();
            if (info == null || !testName.equals(info.getTestName())) continue;
            ++result;
        }
        return result;
    }

    public static int countTimers(Collection<Timer> timers, TimerInfo info) {
        int result = 0;
        for (Timer timer : timers) {
            TimerInfo fo = (TimerInfo)timer.getInfo();
            if (info == null) {
                if (fo != null) continue;
                ++result;
                continue;
            }
            if (!info.equals(fo)) continue;
            ++result;
        }
        return result;
    }

    public static int countTimers(TimerService timerService, TimerInfo info) {
        return TimerUtil.countTimers((Collection<Timer>)timerService.getTimers(), info);
    }

    public static int countTimers(Collection<Timer> timers, ScheduleExpression exp) {
        int result = 0;
        for (Timer timer : timers) {
            if (!timer.isCalendarTimer()) continue;
            ScheduleExpression ex = timer.getSchedule();
            if (exp == null) {
                if (ex != null) continue;
                ++result;
                continue;
            }
            if (!exp.equals(ex)) continue;
            ++result;
        }
        return result;
    }

    public static int countTimers(TimerService timerService, ScheduleExpression exp) {
        return TimerUtil.countTimers((Collection<Timer>)timerService.getTimers(), exp);
    }

    public static Timer findTimer(TimerService timerService, TimerInfo info) {
        return TimerUtil.findTimer((Collection<Timer>)timerService.getTimers(), info);
    }

    public static Timer findTimer(Collection<Timer> timers, TimerInfo info) {
        Timer result = null;
        if (info == null) {
            for (Timer t : timers) {
                if (t.getInfo() != null) continue;
                result = t;
                break;
            }
        } else {
            result = TimerUtil.findTimer(timers, info.getTestName());
        }
        return result;
    }

    public static Timer findTimer(TimerService timerService, ScheduleExpression exp) {
        return TimerUtil.findTimer((Collection<Timer>)timerService.getTimers(), exp);
    }

    public static Timer findTimer(Collection<Timer> timers, ScheduleExpression exp) {
        Timer result = null;
        for (Timer t : timers) {
            if (!t.isCalendarTimer() || !exp.equals(t.getSchedule())) continue;
            result = t;
            break;
        }
        return result;
    }

    public static Timer findTimer(TimerService timerService, String testName) {
        return TimerUtil.findTimer((Collection<Timer>)timerService.getTimers(), testName);
    }

    public static Timer findTimer(Collection<Timer> timers, String testName) {
        Timer result = null;
        for (Timer t : timers) {
            Serializable ser = t.getInfo();
            if (ser == null) continue;
            String timerName = TimerUtil.getTimerName(t);
            Helper.getLogger().info("Checking timer(" + timerName + "): " + t);
            if (!testName.trim().equals(timerName)) continue;
            result = t;
            break;
        }
        return result;
    }

    public static Timer findTimer(TimerService timerService, TimerConfig timerConfig) {
        return TimerUtil.findTimer((Collection<Timer>)timerService.getTimers(), timerConfig);
    }

    public static Timer findTimer(Collection<Timer> timers, TimerConfig timerConfig) {
        return TimerUtil.findTimer(timers, (TimerInfo)timerConfig.getInfo());
    }

    public static boolean containsTimer(Collection<Timer> timers, Timer timer) {
        return timers.contains(timer);
    }

    public static Timer getSingleTimer(TimerService timerService) {
        Collection timers = timerService.getTimers();
        if (timers.size() != 1) {
            throw new IllegalStateException("Expecting 1 timer, but actual " + timers.size());
        }
        Timer timer2 = null;
        for (Timer timer2 : timers) {
        }
        return timer2;
    }

    public static Timer createMillisecondLaterTimer(TimerService timerService, String timerName) {
        return TimerUtil.createMillisecondLaterTimer(timerService, timerName, true);
    }

    public static Timer createMillisecondLaterTimer(TimerService timerService, String timerName, boolean persistent) {
        Date expiration = TimerUtil.getCurrentDatePlus(14, 1);
        Helper.getLogger().logp(Level.FINE, "TimerUtil", "createMilliSecondLaterTimer", "About to create a timer expiring on " + expiration + ", name:" + timerName);
        Timer timer = persistent ? timerService.createTimer(expiration, (Serializable)new TimerInfo(timerName)) : timerService.createSingleActionTimer(expiration, new TimerConfig((Serializable)new TimerInfo(timerName), false));
        Helper.getLogger().logp(Level.FINE, "TimerUtil", "createMilliSecondLaterTimer", "Created a timer expiring on " + expiration + ", name:" + timerName);
        return timer;
    }

    public static Timer createSecondLaterTimer(TimerService timerService) {
        return TimerUtil.createSecondLaterTimer(timerService, (TimerInfo)null);
    }

    public static Timer createSecondLaterTimer(TimerService timerService, String testName) {
        return TimerUtil.createSecondLaterTimer(timerService, new TimerInfo(testName));
    }

    public static Timer createSecondLaterTimer(TimerService timerService, String testName, int seconds) {
        return TimerUtil.createSecondLaterTimer(timerService, new TimerInfo(testName), seconds);
    }

    public static Timer createSecondLaterTimer(TimerService timerService, TimerConfig timerConfig) {
        return TimerUtil.createSecondLaterTimer(timerService, timerConfig, 2);
    }

    public static Timer createSecondLaterTimer(TimerService timerService, TimerConfig timerConfig, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.add(13, seconds);
        return timerService.createCalendarTimer(TimerUtil.getPreciseScheduleExpression(cal), timerConfig);
    }

    public static Timer createSecondLaterTimer(TimerService timerService, TimerInfo info) {
        return TimerUtil.createSecondLaterTimer(timerService, info, 2);
    }

    public static Timer createSecondLaterTimer(TimerService timerService, TimerInfo info, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.add(13, seconds);
        return timerService.createCalendarTimer(TimerUtil.getPreciseScheduleExpression(cal), new TimerConfig((Serializable)info, true));
    }

    public static Date getCurrentDatePlus(int calendarUnit, int amount) {
        Calendar cal = Calendar.getInstance();
        if (amount != 0) {
            cal.add(calendarUnit, amount);
        }
        return cal.getTime();
    }

    public static Calendar getCurrentCalendarPlus(int calendarUnit, int amount) {
        Calendar cal = Calendar.getInstance();
        if (amount != 0) {
            cal.add(calendarUnit, amount);
        }
        return cal;
    }

    public static ScheduleExpression getPreciseScheduleExpression(Calendar ... cals) {
        Calendar cal = cals.length == 0 ? Calendar.getInstance() : cals[0];
        ScheduleExpression exp = new ScheduleExpression().year(cal.get(1)).month(TimerUtil.getForSchedule(2, cal)).dayOfMonth(TimerUtil.getForSchedule(5, cal)).hour(TimerUtil.getForSchedule(11, cal)).minute(TimerUtil.getForSchedule(12, cal)).second(TimerUtil.getForSchedule(13, cal));
        return exp;
    }

    public static Timer createFarFutureTimer(TimerService timerService) {
        return TimerUtil.createFarFutureTimer(timerService, (TimerInfo)null);
    }

    public static Timer createFarFutureTimer(TimerService timerService, TimerInfo info) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 2);
        return timerService.createCalendarTimer(TimerUtil.getPreciseScheduleExpression(cal), new TimerConfig((Serializable)info, true));
    }

    public static Timer createFarFutureTimer(TimerService timerService, TimerConfig timerConfig) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 2);
        return timerService.createCalendarTimer(TimerUtil.getPreciseScheduleExpression(cal), timerConfig);
    }

    public static Timer createFarFutureTimer(TimerService timerService, String testName) {
        return TimerUtil.createFarFutureTimer(timerService, new TimerInfo(testName));
    }

    public static int getForSchedule(int field, Calendar ... calendars) {
        int result = 0;
        Calendar cal = null;
        cal = calendars.length == 0 ? Calendar.getInstance() : calendars[0];
        result = cal.get(field);
        if (field == 7) {
            if (--result == 0) {
                result = Math.random() < 0.5 ? 0 : 7;
            }
        } else if (field == 2) {
            ++result;
        }
        return result;
    }

    public static void checkScheduleDefaults(ScheduleExpression exp, StringBuilder sb) {
        sb.append("Check default schedule attribute values. ");
        Helper.assertEquals(ScheduleAttributeType.SECOND.toString(), "0", exp.getSecond(), sb);
        Helper.assertEquals(ScheduleAttributeType.MINUTE.toString(), "0", exp.getMinute(), sb);
        Helper.assertEquals(ScheduleAttributeType.HOUR.toString(), "0", exp.getHour(), sb);
        Helper.assertEquals(ScheduleAttributeType.MONTH.toString(), "*", exp.getMonth(), sb);
        Helper.assertEquals(ScheduleAttributeType.YEAR.toString(), "*", exp.getYear(), sb);
        Helper.assertEquals(ScheduleAttributeType.DAY_OF_WEEK.toString(), "*", exp.getDayOfWeek(), sb);
        Helper.assertEquals(ScheduleAttributeType.DAY_OF_MONTH.toString(), "*", exp.getDayOfMonth(), sb);
        Helper.assertEquals("start", null, exp.getStart(), sb);
        Helper.assertEquals("end", null, exp.getEnd(), sb);
    }

    public static int getDateField(int field, Calendar ... calendars) {
        Calendar cal = null;
        cal = calendars.length == 0 ? Calendar.getInstance() : calendars[0];
        return cal.get(field);
    }

    public static int getDateField(int field, Date ... dates) {
        Calendar cal = null;
        if (dates.length == 0) {
            cal = Calendar.getInstance();
        } else {
            cal = Calendar.getInstance();
            cal.setTime(dates[0]);
        }
        return cal.get(field);
    }

    public static String getTimerName(Timer timer) {
        if (timer == null) {
            return null;
        }
        Serializable info = timer.getInfo();
        if (info == null) {
            return null;
        }
        String result = null;
        result = info instanceof String ? (String)((Object)info) : (info instanceof TimerInfo ? ((TimerInfo)info).getTestName() : info.toString());
        return result == null ? result : result.trim();
    }

    public static String toString(Timer timer) {
        if (timer == null) {
            return null;
        }
        String s = timer.getInfo() + "\tschedule:" + (timer.isCalendarTimer() ? timer.getSchedule() : null) + "\tnextTimeout:" + timer.getNextTimeout() + "\ttimeRemaining:" + timer.getTimeRemaining() + "\tisPersistent:" + timer.isPersistent();
        return s;
    }

    public static String toString(ScheduleExpression exp) {
        if (exp == null) {
            return null;
        }
        Date start = exp.getStart();
        Date end = exp.getEnd();
        return "year=" + exp.getYear() + " month=" + exp.getMonth() + " dayOfMonth=" + exp.getDayOfMonth() + " dayOfWeek=" + exp.getDayOfWeek() + " hour=" + exp.getHour() + " minute=" + exp.getMinute() + " second=" + exp.getSecond() + " start=" + start + " end=" + end + " timezone=" + exp.getTimezone();
    }

    public static int getNextLeapYear(int ... baseYears) {
        GregorianCalendar cal = new GregorianCalendar();
        int baseYear = baseYears.length == 0 ? cal.get(1) : baseYears[0];
        int i = baseYear + 1;
        while (!cal.isLeapYear(i)) {
            ++i;
        }
        return i;
    }
}

