/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedTopicSession;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedTopicSessionTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejbjspservlet.closedTopicSession.ClosedTopicSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private static JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicSessionTests theTests = new ClosedTopicSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type) throws Exception {
        if (type == 1 || type == 3) {
            tool = new JmsTool(type, this.jmsUser, this.jmsPassword, this.mode);
            tool.getDefaultTopicConnection().start();
            this.logMsg("Closing topic session");
            tool.getDefaultTopicSession().close();
        }
        this.logMsg("Session closed");
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedTopicSessionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultTopicSubscriber().setMessageListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionSetMessageListenerTest", e);
        }
    }

    public void closedTopicSessionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultTopicSubscriber().getMessageListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSessionGetMessageListenerTest", e);
        }
    }
}

