/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedlogoff;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedlogoff.WSCCloseHttpSessionServer;
import java.io.IOException;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="platform"), @Tag(value="web")})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -7084128651642590169L;
    String user;
    String password;
    int reason = 0;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_platform_jakarta_websocket_handshakeresponse_authenticated_logoff_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.platform.jakarta.websocket.server.handshakerequest.authenticatedlogoff"});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addAsWebInfResource(WSCClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_platform_jakarta_websocket_handshakeresponse_authenticated_logoff_web");
    }

    @BeforeEach
    public void setup() throws Exception {
        this.user = WSCClientIT.assertProperty((Properties)new Properties(), (String)"user");
        this.password = WSCClientIT.assertProperty((Properties)new Properties(), (String)"password");
        super.setup();
    }

    @Test
    public void connectionHasBeenClosedWithStatus1008AfterInvalidationTest() throws Exception {
        this.connectionHasBeenClosedWithStatus1008After(0);
    }

    void addAuthorisation() {
        this.setProperty(WebSocketCommonClient.Property.BASIC_AUTH_USER, this.user);
        this.setProperty(WebSocketCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
    }

    void connectionHasBeenClosedWithStatus1008After(int opId) throws Exception {
        boolean closed = false;
        String[] messages = WSCCloseHttpSessionServer.MESSAGES;
        this.logExceptionOnInvocation(false);
        this.addAuthorisation();
        try {
            this.invoke("closehttpsession", messages[opId], messages[opId], false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            TestUtil.sleepSec((int)5);
            this.invokeAgain("ok", "ok", true);
        }
        catch (Exception e) {
            closed = true;
            WSCClientIT.logTrace((Object[])new Object[]{"Connection has been closed as expected:", WSCClientIT.getCauseMessage((Throwable)e)});
        }
        WSCClientIT.assertTrue((boolean)closed, (Object[])new Object[]{"The connection has not been immediatelly closed"});
        this.addAuthorisation();
        this.invoke("closehttpsession", messages[2], new String[]{"1008"});
        WSCClientIT.logMsg((Object[])new Object[]{"After invalidation of HTTP session, connection has been closed with expected status 1008"});
    }
}

