/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta6;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient6
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta6";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient6 theTests = new dbMetaClient6();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testGetCatalogSeparator() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getCatalogSeparator");
            String sRetValue = this.dbmd.getCatalogSeparator();
            if (sRetValue == null) {
                this.msg.setMsg("getCatalogSeparator is not supported");
            } else {
                this.msg.setMsg("getCatalogSeparator returns " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCatalogSeparator is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCatalogSeparator is Failed!");
        }
    }

    public void testSupportsSchemasInDataManipulation() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSchemasInDataManipulation");
            boolean retValue = this.dbmd.supportsSchemasInDataManipulation();
            if (retValue) {
                this.msg.setMsg("supportsSchemasInDataManipulation is supported");
            } else {
                this.msg.setMsg("supportsSchemasInDataManipulation is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSchemasInDataManipulation is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSchemasInDataManipulation is Failed!");
        }
    }

    public void testSupportsSchemasInProcedureCalls() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSchemasInProcedureCalls");
            boolean retValue = this.dbmd.supportsSchemasInProcedureCalls();
            if (retValue) {
                this.msg.setMsg("supportsSchemasInProcedureCalls is supported");
            } else {
                this.msg.setMsg("supportsSchemasInProcedureCalls is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSchemasInProcedureCalls is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSchemasInProcedureCalls is Failed!");
        }
    }

    public void testSupportsSchemasInTableDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSchemasInTableDefinitions");
            boolean retValue = this.dbmd.supportsSchemasInTableDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsSchemasInTableDefinitions is supported");
            } else {
                this.msg.setMsg("supportsSchemasInTableDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSchemasInTableDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSchemasInTableDefinitions is Failed!");
        }
    }

    public void testSupportsSchemasInIndexDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSchemasInIndexDefinitions");
            boolean retValue = this.dbmd.supportsSchemasInIndexDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsSchemasInIndexDefinitions is supported");
            } else {
                this.msg.setMsg("supportsSchemasInIndexDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSchemasInIndexDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSchemasInIndexDefinitions is Failed!");
        }
    }

    public void testSupportsSchemasInPrivilegeDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSchemasInPrivilegeDefinitions");
            boolean retValue = this.dbmd.supportsSchemasInPrivilegeDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsSchemasInPrivilegeDefinitions is supported");
            } else {
                this.msg.setMsg("supportsSchemasInPrivilegeDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSchemasInPrivilegeDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSchemasInPrivilegeDefinitions is Failed!");
        }
    }

    public void testSupportsCatalogsInDataManipulation() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCatalogsInDataManipulation");
            boolean retValue = this.dbmd.supportsCatalogsInDataManipulation();
            if (retValue) {
                this.msg.setMsg("supportsCatalogsInDataManipulation is supported");
            } else {
                this.msg.setMsg("supportsCatalogsInDataManipulation is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCatalogsInDataManipulation is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCatalogsInDataManipulation is Failed!");
        }
    }

    public void testSupportsCatalogsInProcedureCalls() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCatalogsInProcedureCalls");
            boolean retValue = this.dbmd.supportsCatalogsInProcedureCalls();
            if (retValue) {
                this.msg.setMsg("supportsCatalogsInProcedureCalls is supported");
            } else {
                this.msg.setMsg("supportsCatalogsInProcedureCalls is not supported");
            }
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCatalogsInProcedureCalls is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCatalogsInProcedureCalls is Failed!");
        }
    }

    public void testSupportsCatalogsInTableDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCatalogsInTableDefinitions()");
            boolean retValue = this.dbmd.supportsCatalogsInTableDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsCatalogsInTableDefinitions is supported");
            } else {
                this.msg.setMsg("supportsCatalogsInTableDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCatalogsInTableDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCatalogsInTableDefinitions is Failed!");
        }
    }

    public void testSupportsCatalogsInIndexDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCatalogsInIndexDefinitions");
            boolean retValue = this.dbmd.supportsCatalogsInIndexDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsCatalogsInIndexDefinitions is supported");
            } else {
                this.msg.setMsg("supportsCatalogsInIndexDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCatalogsInIndexDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCatalogsInIndexDefinitions is Failed!");
        }
    }

    public void testSupportsCatalogsInPrivilegeDefinitions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions");
            boolean retValue = this.dbmd.supportsCatalogsInPrivilegeDefinitions();
            if (retValue) {
                this.msg.setMsg("supportsCatalogsInPrivilegeDefinitions is supported");
            } else {
                this.msg.setMsg("supportsCatalogsInPrivilegeDefinitions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCatalogInPrivilegeDefinitions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCatalogInPrivilegeDefinitions is Failed!");
        }
    }

    public void testSupportsPositionedDelete() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsPositionedDelete");
            boolean retValue = this.dbmd.supportsPositionedDelete();
            if (retValue) {
                this.msg.setMsg("supportsPositionedDelete is supported");
            } else {
                this.msg.setMsg("supportsPositionedDelete is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsPositionedDelete is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsPositionedDelete is Failed!");
        }
    }

    public void testSupportsPositionedUpdate() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsPositionedUpdate");
            boolean retValue = this.dbmd.supportsPositionedUpdate();
            if (retValue) {
                this.msg.setMsg("supportsPositionedUpdate is supported");
            } else {
                this.msg.setMsg("supportsPositionedUpdate is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsPositionedUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsPositionedUpdate is Failed!");
        }
    }

    public void testSupportsSelectForUpdate() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSelectForUpdate");
            boolean retValue = this.dbmd.supportsSelectForUpdate();
            if (retValue) {
                this.msg.setMsg("supportsSelectForUpdate is supported");
            } else {
                this.msg.setMsg("supportsSelectForUpdate is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSelectForUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSelectForUpdate is Failed!");
        }
    }

    public void testSupportsSubqueriesInComparisons() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSubqueriesInComparisons");
            boolean retValue = this.dbmd.supportsSubqueriesInComparisons();
            if (retValue) {
                this.msg.setMsg("supportsSubqueriesInComparisons is supported");
            } else {
                this.msg.setMsg("supportsSubqueriesInComparisons is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSubqueriesInComparisons is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSubqueriesInComparisons is Failed!");
        }
    }

    public void testSupportsSubqueriesInExists() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSubqueriesInExists");
            boolean retValue = this.dbmd.supportsSubqueriesInExists();
            if (retValue) {
                this.msg.setMsg("supportsSubqueriesInExists is supported");
            } else {
                this.msg.setMsg("supportsSubqueriesInExists is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSubqueriesInExists is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSubqueriesInExists is Failed!");
        }
    }

    public void testSupportsSubqueriesInIns() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSubqueriesInIns");
            boolean retValue = this.dbmd.supportsSubqueriesInIns();
            if (retValue) {
                this.msg.setMsg("supportsSubqueriesInIns is supported");
            } else {
                this.msg.setMsg("supportsSubqueriesInIns is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSubqueriesInIns is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSubqueriesInIns is Failed!");
        }
    }

    public void testSupportsSubqueriesInQuantifieds() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsSubqueriesInQuantifieds");
            boolean retValue = this.dbmd.supportsSubqueriesInQuantifieds();
            if (retValue) {
                this.msg.setMsg("supportsSubqueriesInQuantifieds is supported");
            } else {
                this.msg.setMsg("supportsSubqueriesInQuantifieds is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsSubqueriesInQuantifieds is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsSubqueriesInQuantifieds is Failed!");
        }
    }

    public void testSupportsCorrelatedSubqueries() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsCorrelatedSubqueries");
            boolean retValue = this.dbmd.supportsCorrelatedSubqueries();
            if (retValue) {
                this.msg.setMsg("supportsCorrelatedSubqueries is supported");
            } else {
                this.msg.setMsg("supportsCorrelatedSubqueries is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCorrelatedSubqueries is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCorrelatedSubqueries is Failed!");
        }
    }

    public void testSupportsUnion() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsUnion");
            boolean retValue = this.dbmd.supportsUnion();
            if (retValue) {
                this.msg.setMsg("supportsUnion is supported");
            } else {
                this.msg.setMsg("supportsUnion is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsUnion is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsUnion is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

