/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation;

import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSLogRecord;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSXMLFormatter;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class TSLogger
extends Logger {
    public static final String MESSAGE_PREFIX = "JPA_ALTERNATE_PROVIDER : ";
    public static final String LOG_NAME = "JPALog.xml";
    public static final DateFormat df = new SimpleDateFormat("dd-MM-yyyy'T'HH:mm:ss.SSS");
    private String contextId;
    private int levelValue = Level.INFO.intValue();
    private int offValue = Level.OFF.intValue();
    private Filter filter;
    private String name;
    private static TSLogger tsLogger = null;
    private static TSLogger logger = TSLogger.getInstance();

    protected TSLogger(String name) {
        super(name, null);
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    public static synchronized TSLogger getTSLogger(String name) {
        TSLogger result = null;
        LogManager manager = LogManager.getLogManager();
        if (tsLogger != null) {
            if (tsLogger.getName().equals(name)) {
                result = tsLogger;
            }
        } else {
            result = new TSLogger(name);
            manager.addLogger(result);
        }
        return result;
    }

    public void log(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, this.createDateTime(), MESSAGE_PREFIX + msg, "JPA");
    }

    public void log(Level level, String dateTime, String msg) {
        this.log(level, dateTime, MESSAGE_PREFIX + msg, "JPA");
    }

    public void log(Level level, String dateTime, String msg, String contextId) {
        if (level.intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogRecord lr = new TSLogRecord(level, dateTime, msg, contextId);
        String rbn = null;
        for (Logger target = this; target != null && (rbn = target.getResourceBundleName()) == null; target = target.getParent()) {
        }
        if (rbn != null) {
            lr.setResourceBundleName(rbn);
        }
        this.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(TSLogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogger tSLogger = this;
        synchronized (tSLogger) {
            if (this.filter != null && !this.filter.isLoggable(record)) {
                return;
            }
        }
        TSLogger logger = this;
        while (logger != null) {
            Handler[] targets = logger.getHandlers();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    if (!(targets[i] instanceof FileHandler)) continue;
                    targets[i].publish(record);
                }
            }
            if (!logger.getUseParentHandlers()) break;
            logger = null;
        }
    }

    public static TSLogger getInstance() {
        if (logger == null) {
            try {
                String logFileLocation = System.getProperty("log.file.location");
                if (logFileLocation != null) {
                    System.out.println("JPA_ALTERNATE_PROVIDER log.file.location:" + logFileLocation);
                    File dir = new File(logFileLocation);
                    String[] chld = dir.list();
                    if (chld == null) {
                        System.out.println("Appserver log directory does not exist or is not a directory.");
                    } else {
                        System.out.println("Searching for previous log files to delete");
                        for (int i = 0; i < chld.length; ++i) {
                            File file;
                            String fileName = chld[i];
                            if (fileName.indexOf(LOG_NAME) < 0 || !(file = new File(logFileLocation + "/" + fileName)).exists()) continue;
                            System.out.println("Deleting JPA logfile:" + file.getName());
                            file.delete();
                        }
                    }
                    System.out.println("JPA_ALTERNATE_PROVIDER log:" + logFileLocation + "/JPALog.xml");
                    logger = TSLogger.getTSLogger("JPA");
                    boolean appendMode = false;
                    FileHandler fileHandler = new FileHandler(logFileLocation + "/JPALog.xml", appendMode);
                    fileHandler.setFormatter(new TSXMLFormatter());
                    logger.addHandler(fileHandler);
                } else {
                    System.out.println("JPA_ALTERNATE_PROVIDER: log.file.location not set, using default logger");
                    logger = TSLogger.getTSLogger("JPA");
                    logger.log(Level.SEVERE, "log.file.location not set: Using default logger");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("TSLogger Initialization failed", e);
            }
        }
        return logger;
    }

    public String createDateTime() {
        return df.format(new Date());
    }
}

