/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.listener;

import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.session.listener.SimpleSessionBean;
import org.jboss.cdi.tck.util.ActionSequence;

@WebServlet(name="IntrospectServlet", urlPatterns={"/introspect"})
public class IntrospectServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String MODE_INVALIDATE = "invalidate";
    public static final String MODE_VERIFY = "verify";
    public static final String MODE_TIMEOUT = "timeout";
    static boolean isSessionScopeActive = true;
    @Inject
    SimpleSessionBean simpleBean;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/text");
        String mode = req.getParameter("mode");
        if (mode == null) {
            resp.getWriter().append(this.simpleBean.getId());
        } else if (MODE_INVALIDATE.equals(mode)) {
            ActionSequence.reset();
            ActionSequence.addAction((String)IntrospectServlet.class.getName());
            req.getSession().invalidate();
        } else if (MODE_VERIFY.equals(mode)) {
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().write("" + isSessionScopeActive);
        } else if (MODE_TIMEOUT.equals(mode)) {
            ActionSequence.reset();
            req.getSession().setMaxInactiveInterval(1);
        } else {
            throw new ServletException("Unknown mode");
        }
    }
}

