/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.tx;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBaseWithoutTimeOutMethod;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import java.io.Serializable;

public abstract class ScheduleTxBeanBase
extends TimerBeanBaseWithoutTimeOutMethod {
    protected abstract void setRollbackOnly();

    protected abstract void beginTransaction();

    protected abstract void commitTransaction();

    @Timeout
    private void ejbTimeout(Timer timer) {
        this.beginTransaction();
        super.timeout(timer);
        Serializable o = timer.getInfo();
        if (o != null) {
            TimerInfo info = (TimerInfo)o;
            String name = info.getTestName();
            if ("timeoutRollback".equals(name)) {
                Helper.getLogger().fine("About to setRollbackOnly for test timeoutRollback.");
                this.setRollbackOnly();
            } else if ("timeoutSystemException".equals(name) || "timeoutSystemExceptionBMT".equals(name)) {
                throw new RuntimeException("For test " + name + ", transaction must fail in timeout method and retry at least once.");
            }
        }
        this.commitTransaction();
    }

    public String createRollback(TimerConfig timerConfig) {
        this.beginTransaction();
        Timer timer = TimerUtil.createSecondLaterTimer((TimerService)this.timerService, (TimerConfig)timerConfig);
        Helper.busyWait((long)1500L);
        this.setRollbackOnly();
        this.commitTransaction();
        return "Created a timer within tx: " + timer + ". Set the tx to rollback.";
    }

    public String cancelRollback(String name) {
        this.beginTransaction();
        Timer timer = TimerUtil.findTimer((TimerService)this.timerService, (String)name);
        timer.cancel();
        this.setRollbackOnly();
        this.commitTransaction();
        return "Cancelled a timer within tx: " + timer + ". Set the tx to rollback.";
    }
}

