/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.HardwareProduct;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.Product;
import ee.jakarta.tck.persistence.jpa22.se.repeatable.secondarytable.SoftwareProduct;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void subClassInheritsCacheableTrue() throws Exception {
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block12: {
            pass1 = false;
            pass2 = false;
            pass3 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Product product = new Product("1", 101);
                    em2.persist((Object)product);
                    this.logTrace("persisted Product " + product);
                    SoftwareProduct sp = new SoftwareProduct();
                    sp.setId("2");
                    sp.setRevisionNumber(1.0);
                    sp.setQuantity(202);
                    em2.persist((Object)sp);
                    this.logTrace("persisted SoftwareProduct " + sp);
                    HardwareProduct hp = new HardwareProduct();
                    hp.setId("3");
                    hp.setModelNumber(3);
                    hp.setQuantity(303);
                    em2.persist((Object)hp);
                    this.logTrace("persisted HardwareProduct " + hp);
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Product.class, (Object)"1");
                        if (b1) {
                            this.logTrace("Cache returned: " + b1 + ", therefore cache does contain Product " + product);
                            pass1 = true;
                        } else {
                            this.logErr("Cache returned: " + b1 + ", therefore cache does not contain Product " + product);
                        }
                        boolean b2 = cache.contains(SoftwareProduct.class, (Object)"2");
                        if (!b2) {
                            this.logTrace("Cache returned: " + b2 + ", therefore cache does not contain SoftwareProduct " + sp);
                            pass2 = true;
                        } else {
                            this.logErr("Cache returned: " + b2 + ", therefore cache does contain SoftwareProduct " + sp);
                        }
                        boolean b3 = cache.contains(HardwareProduct.class, (Object)"3");
                        if (b3) {
                            this.logTrace("Cache returned: " + b3 + ", therefore cache does contain HardwareProduct " + hp);
                            pass3 = true;
                        } else {
                            this.logErr("Cache returned: " + b3 + ", therefore cache does not contain HardwareProduct " + hp);
                        }
                        break block12;
                    }
                    this.logErr("Cache returned was null");
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                }
            } else {
                this.logMsg("Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
                pass3 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("subClassInheritsCacheableTrue failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

