/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Department;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Employee2;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Employee3;
import jakarta.persistence.EntityGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(new Properties());
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        super.cleanup();
    }

    public void entityGraphGetNameNoNameExistsTest() throws Exception {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                this.logTrace("Received expected name:" + e.getName());
                pass = true;
            } else {
                this.logErr("Expected name: Employee2, actual:" + e.getName());
            }
        } else {
            this.logErr("Expected 1 graph to be returned, instead got:" + egs.size());
        }
        if (!pass) {
            throw new Exception("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    public void getNameTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            this.logTrace("Received expected null");
            pass = true;
        } else {
            this.logErr("Expected name: null, actual:" + eg.getName());
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }

    public void getEntityGraphsClassTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Expected results");
                for (String s : expected) {
                    this.logErr("expected:" + s);
                }
                this.logErr("Actual results");
                for (String s : actual) {
                    this.logErr("actual:" + s);
                }
            }
        } else {
            this.logErr("No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                this.logTrace("persisted department:" + department);
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee3:" + (Employee3)serializable);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

