/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.client;

import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.jstl.common.JstlTckConstants;
import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class CompatAbstractUrlClient
extends AbstractUrlClient
implements JstlTckConstants {
    protected Properties dbArgs = new Properties();
    protected static final String STANDARD_COMPAT = "standardCompat";

    @Override
    @BeforeEach
    public void setup() throws Exception {
        for (int i = 0; i < JSTL_DB_PROPS.length; ++i) {
            String s = System.getProperty(JSTL_DB_PROPS[i]);
            Assertions.assertTrue((!this.isNullOrEmpty(s) ? 1 : 0) != 0, (String)("[CompatAbstractUrlClient] '" + JSTL_DB_PROPS[i] + "' was not set."));
            if (s == null) continue;
            this.dbArgs.setProperty(JSTL_DB_PROPS[i], s.trim());
        }
        super.setup();
    }

    @Override
    protected void setTestProperties(WebTestCase testCase) {
        String test;
        this.setStandardProperties(TEST_PROPS.getProperty(STANDARD_COMPAT), testCase);
        if (testCase.getRequest() == null && (test = TEST_PROPS.getProperty("request")).indexOf("HTTP/") < 0) {
            StringBuffer sb = new StringBuffer(25);
            sb.append("GET ").append(this.getContextRoot()).append("/").append(test).append(" HTTP/1.1");
            HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
            testCase.setRequest(req);
        }
        super.setTestProperties(testCase);
        HttpRequest httpReq = testCase.getRequest();
        Enumeration<?> enumm = this.dbArgs.propertyNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String value = this.dbArgs.getProperty(name);
            httpReq.addRequestHeader(name, value);
        }
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        if (testValue == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        this._testName = testValue;
        sb.append("GET ").append(this._contextRoot).append("/");
        sb.append(testValue).append(".jsp").append(" HTTP/1.1");
        HttpRequest req = new HttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
    }
}

