/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta4;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient4
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta4";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient4 theTests = new dbMetaClient4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsConvert23() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(STRUCT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2002, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(STRUCT VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(STRUCT VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert24() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(TIME, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(92, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(TIME VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(TIME VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert25() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(TIMESTAMP, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(93, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(TIMESTAMP VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(TIMESTAMP VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert26() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(TINYINT, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-6, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(TINYINT VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(TINYINT VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert27() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(VARBINARY, VARCHAR) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-3, 12);
            if (retValue) {
                this.msg.setMsg("supportsConvert(VARBINARY VARCHAR) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(VARBINARY VARCHAR) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert28() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(BIGINT, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-5, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(BIGINT, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BIGINT, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert29() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(BIT, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-7, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(BIT, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(BIT, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert30() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(DATE, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(91, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DATE, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DATE, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert31() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(DECIMAL, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(3, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DECIMAL, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DECIMAL, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert32() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(DOUBLE, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(8, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(DOUBLE, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(DOUBLE, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert33() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(FLOAT, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(6, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(FLOAT, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(FLOAT, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert34() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(NUMERIC, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(2, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(NUMERIC, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(NUMERIC, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert35() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(REAL, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(7, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(REAL, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(REAL, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert36() throws Exception {
        try {
            boolean retValue = this.dbmd.supportsConvert(5, 4);
            this.msg.setMsg("Calling supportsConvert(SMALLINT, INTEGER) on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsConvert(SMALLINT, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(SMALLINT, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsConvert37() throws Exception {
        try {
            this.msg.setMsg("Calling supportsConvert(TINYINT, INTEGER) on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsConvert(-6, 4);
            if (retValue) {
                this.msg.setMsg("supportsConvert(TINYINT, INTEGER) method is supported");
            } else {
                this.msg.setMsg("supportsConvert(TINYINT, INTEGER) method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsConvert is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsConvert is Failed!");
        }
    }

    public void testSupportsTableCorrelationNames() throws Exception {
        try {
            this.msg.setMsg("Calling supportsTableCorrelationNames on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsTableCorrelationNames();
            if (retValue) {
                this.msg.setMsg("supportsTableCorrelationNames method is supported");
            } else {
                this.msg.setMsg("supportsTableCorrelationNames method is not supported");
            }
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTableCorrelationNames is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTableCorrelationNames is Failed!");
        }
    }

    public void testSupportsDifferentTableCorrelationNames() throws Exception {
        try {
            this.msg.setMsg("Calling supportsDifferentTableCorrelationNames on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsDifferentTableCorrelationNames();
            if (retValue) {
                this.msg.setMsg("supportsDifferentTableCorrelationNames method is supported");
            } else {
                this.msg.setMsg("supportsDifferentTableCorrelationNames method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsDifferentTableCorrelationNames is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsDifferentTableCorrelationNames is Failed!");
        }
    }

    public void testSupportsExpressionsInOrderBy() throws Exception {
        try {
            this.msg.setMsg("Calling supportsExpressionsInOrderBy on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsExpressionsInOrderBy();
            if (retValue) {
                this.msg.setMsg("supportsExpressionsInOrderBy method is supported");
            } else {
                this.msg.setMsg("supportsExpressionsInOrderBy method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsExpressionsInOrderBy is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsExpressionsInOrderBy is Failed!");
        }
    }

    public void testSupportsOrderByUnrelated() throws Exception {
        try {
            this.msg.setMsg("Calling supportsOrderByUnrelated on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsOrderByUnrelated();
            if (retValue) {
                this.msg.setMsg("supportsOrderByUnrelated method is supported");
            } else {
                this.msg.setMsg("supportsOrderByUnrelated method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOrderByUnrelated is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOrderByUnrelated is Failed!");
        }
    }

    public void testSupportsGroupBy() throws Exception {
        try {
            this.msg.setMsg("Calling supportsGroupBy on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsGroupBy();
            if (retValue) {
                this.msg.setMsg("supportsGroupBy method is supported");
            } else {
                this.msg.setMsg("supportsGroupBy method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsGroupBy is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsGroupBy is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

