/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.convert;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.convert.Address;
import ee.jakarta.tck.persistence.core.annotations.convert.B;
import ee.jakarta.tck.persistence.core.annotations.convert.Country;
import ee.jakarta.tck.persistence.core.annotations.convert.Customer;
import ee.jakarta.tck.persistence.core.annotations.convert.Employee;
import ee.jakarta.tck.persistence.core.annotations.convert.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.annotations.convert.FullTimeEmployee2;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void convertTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            this.logTrace("Persisting Employee");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Employees and verify them and their departments");
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)expected.getId());
            if (emp != null) {
                this.logTrace("Found employee: " + emp.getId());
                expected.setSalary(expected.getSalary().replace("#", ""));
                if (emp.equals(expected)) {
                    this.logTrace("Received expected employee:" + emp.toString());
                    pass = true;
                } else {
                    this.logErr("Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                this.logErr("Find returned null Employee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("convertTest failed");
        }
    }

    public void convertExceptionDuringPersistTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("isActive():" + this.getEntityTransaction().isActive());
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.logErr("Did not received expected PersistenceException");
        }
        catch (PersistenceException pe) {
            this.logTrace("Received expected PersistenceException");
            if (this.getEntityTransaction().getRollbackOnly()) {
                this.logTrace("Transaction was marked for rollback");
                pass = true;
            } else {
                this.logErr("Transaction was not marked for rollback");
            }
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("convertExceptionDuringPersistTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertExceptionDuringLoadTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("isActive():" + this.getEntityTransaction().isActive());
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -2));
            this.logTrace("Persisting B");
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            try {
                this.logTrace("Finding B");
                B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
                this.logErr("Did not received expected PersistenceException");
            }
            catch (PersistenceException pe) {
                this.logTrace("Received expected PersistenceException");
                if (this.getEntityTransaction().getRollbackOnly()) {
                    this.logTrace("Transaction was marked for rollback");
                    pass = true;
                } else {
                    this.logErr("Transaction was not marked for rollback");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logErr("Unexpected exception received:", ex);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception re) {
                    this.logErr("Unexpected Exception while rolling back TX:", re);
                }
            }
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("convertExceptionDuringLoadTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            String street = "500.Oracle.Parkway";
            String city = "Redwood Shores";
            B b = new B("1", "name1", 1000, new Address(street, city, 1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
            this.logTrace("B:" + b1.toString());
            if (b1.getBValue().equals(1110)) {
                this.logTrace("Received expected value:" + b1.getBValue());
                pass1 = true;
            } else {
                this.logErr("Converter was not properly applied, expected value:1002, actual" + b1.getBValue());
            }
            Address a = b1.getAddress();
            if (a.getStreet().equals(street.replace(".", "_"))) {
                this.logTrace("Received expected street:" + a.getStreet());
                pass2 = true;
            } else {
                this.logErr("Converter was not properly applied, expected street:" + street + ", actual:" + a.getStreet());
            }
            if (a.getState() == 1) {
                this.logTrace("Received expected state:" + a.getState());
                pass3 = true;
            } else {
                this.logErr("Converter was not properly applied, expected state: 1, actual: " + a.getState());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("convertsTest failed");
        }
    }

    public void mappedSuperClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            char[] c = new char[]{'D', 'o', 'e'};
            FullTimeEmployee expected = new FullTimeEmployee(1, "John", c, "3#5#0#0#0.0");
            this.logTrace("Persisting FullTimeEmployee:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee emp = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)expected.getId());
            if (emp != null) {
                this.logTrace("Found FullTimeEmployee: " + emp.getId());
                expected.setSalary(expected.getSalary().replace("#", ""));
                c = new char[]{'J', 'a', 'm', 'e', 's'};
                expected.setLastName(c);
                if (emp.equals(expected)) {
                    this.logTrace("Received expected FullTimeEmployee:" + emp.toString());
                    pass = true;
                } else {
                    this.logErr("Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                this.logErr("Find returned null FullTimeEmployee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("mappedSuperClassTest failed");
        }
    }

    public void mappedSuperClass2Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            FullTimeEmployee2 expected = new FullTimeEmployee2(1, "J.o.h.n", "Hill", "3500.0");
            this.logTrace("Persisting FullTimeEmployee2:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee2 emp = (FullTimeEmployee2)this.getEntityManager().find(FullTimeEmployee2.class, (Object)expected.getId());
            if (emp != null) {
                this.logTrace("Found FullTimeEmployee2: " + emp.getId());
                expected.setFirstName(expected.getFirstName().replace(".", "#"));
                if (emp.equals(expected)) {
                    this.logTrace("Received expected FullTimeEmployee:" + emp.toString());
                    pass = true;
                } else {
                    this.logErr("Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                this.logErr("Find returned null FullTimeEmployee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("mappedSuperClass2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing JPQL");
            List o = this.getEntityManager().createQuery("Select e from Employee e WHERE e.id = 1", Employee.class).getResultList();
            if (o.size() == 1) {
                Employee emp = (Employee)o.get(0);
                this.logTrace("Employee:" + emp.toString());
                if (emp.getSalary().equals("35000.0")) {
                    this.logTrace("Received expected value:" + emp.getSalary());
                    pass2 = true;
                } else {
                    this.logErr("Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary());
                }
            } else {
                this.logErr("Expected 1 entity to be returned, actual:" + o.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Criteria");
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            if (cquery != null) {
                this.logTrace("Obtained Non-null Criteria Query");
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee).where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
                Employee emp = (Employee)this.getEntityManager().createQuery(cquery).getSingleResult();
                if (emp != null) {
                    this.logTrace("Employee:" + emp.toString());
                    if (emp.getSalary().equals("35000.0")) {
                        this.logTrace("Received expected value:" + emp.getSalary());
                        pass3 = true;
                    } else {
                        this.logErr("Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary());
                    }
                } else {
                    this.logErr("Null Employee result was returned");
                }
            } else {
                this.logErr("createQuery returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("converts2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert3Test() throws Exception {
        Object expected;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            expected = new Employee(1, "Alan", "Smith", "0");
            this.getEntityManager().persist(expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing JPQL");
            expected = "54321.0";
            this.getEntityManager().createQuery("Update Employee e set e.salary='5#4#3#2#1.0'  WHERE e.id = 1").executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp != null) {
                this.logTrace("Found employee: " + emp.getId());
                if (emp.getSalary().equals(expected)) {
                    this.logTrace("Received expected value:" + emp.getSalary());
                    pass2 = true;
                } else {
                    this.logErr("Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary());
                }
            } else {
                this.logErr("Find returned null Employee");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Criteria");
            expected = "3500.0";
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Employee.class);
            Root employee = cd.from(Employee.class);
            this.logTrace("Obtained expected root");
            cd.set("salary", (Object)"3#5#0#0.0");
            cd.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            if (actual == 1) {
                this.clearCache();
                this.getEntityTransaction().begin();
                Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
                if (emp != null) {
                    this.logTrace("Found employee: " + emp.getId());
                    if (emp.getSalary().equals("3500.0")) {
                        this.logTrace("Received expected value:" + emp.getSalary());
                        pass3 = true;
                    } else {
                        this.logErr("Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary());
                    }
                } else {
                    this.logErr("Find returned null Employee instead of:" + (String)expected);
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("Expected 1 update, actual:" + actual);
            }
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception received:", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception while rolling back TX:", re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("converts3Test failed");
        }
    }

    public void embeddedTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String name = "john smith";
            String country = "United States";
            Customer expected = new Customer("1", name, new Country(country, "USA"));
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer: " + cust.toString());
                String tmp = country.replace(" ", "_");
                if (cust.getCountry().getCountry().equals(tmp)) {
                    this.logTrace("Received expected Country:" + cust.getCountry().getCountry());
                    pass = true;
                } else {
                    this.logErr("Expected:" + tmp + ", actual:" + cust.getCountry().getCountry());
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("embeddedTest failed");
        }
    }

    public void elementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> phones = new ArrayList<String>();
            phones.add("781,442,2010");
            phones.add("781,442,2011");
            phones.add("781,442,2012");
            ArrayList<String> expectedphones = new ArrayList<String>();
            for (String p : phones) {
                expectedphones.add(p.replace(",", "-"));
            }
            expected.setPhones(phones);
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("phone:" + s);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (String s : expectedphones) {
                        this.logTrace("expected:" + s);
                    }
                    this.logErr("actual:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("actual:" + s);
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicType failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM B_EMBEDDABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

