/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.variablemapper;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.util.Properties;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;

@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ELClientTest.class.getName());
    private Properties testProps = System.getProperties();

    public static void main(String[] args) {
        ELClientTest theTests = new ELClientTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    public void variableMapperTest() throws Exception {
        ValueExpression vexp5;
        ValueExpression vexp4;
        ValueExpression vexp3;
        ValueExpression vexp1;
        ValueExpression vexp2;
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        VarMapperELContext context = new VarMapperELContext(this.testProps);
        VariableMapper varMapper = context.getVariableMapper();
        TestUtil.logTrace((String)("VariableMapper is " + varMapper.toString()));
        if (varMapper.resolveVariable("foo") != null) {
            pass = false;
            buf.append("Expected call to resolveVariable() to unassigned variable to return null" + TestUtil.NEW_LINE + "Instead call returned " + varMapper.resolveVariable("foo") + TestUtil.NEW_LINE);
        }
        if ((vexp2 = varMapper.setVariable("foo", vexp1 = expFactory.createValueExpression((ELContext)context, "${bar}", String.class))) != null) {
            pass = false;
            buf.append("Expected call to setVariable() to return null for previously unassigned variable" + TestUtil.NEW_LINE + "Instead return value was " + vexp2 + TestUtil.NEW_LINE);
        }
        if (!(vexp3 = varMapper.resolveVariable("foo")).equals((Object)vexp1)) {
            pass = false;
            buf.append("Expected call to resolveVariable() to assigned variable to return " + vexp1.toString() + TestUtil.NEW_LINE + "Instead call returned " + vexp3.toString() + TestUtil.NEW_LINE);
        }
        if (!(vexp4 = varMapper.setVariable("foo", null)).equals((Object)vexp1)) {
            pass = false;
            buf.append("Expected call to resolveVariable() to assigned variable to return " + vexp1.toString() + TestUtil.NEW_LINE + "Instead call returned " + vexp4.toString() + TestUtil.NEW_LINE);
        }
        if ((vexp5 = varMapper.resolveVariable("foo")) != null) {
            pass = false;
            buf.append("Expected call to resolveVariable() to return null after unassignment" + TestUtil.NEW_LINE + "Instead return value was " + vexp5 + TestUtil.NEW_LINE);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }
}

