/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.expression;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELContext;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "expression_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="expression_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"expression_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ExpressionTest.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ELClientServletTest.class, BareBonesELContext.class, ELTestUtil.class, SimpleELContext.class, SimpleELContext.Resolver.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void negativeEqualsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        try {
            MethodExpression mexp2;
            ValueExpression vexp2;
            MethodExpression mexp1;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            ValueExpression vexp1 = expFactory.createValueExpression(context, "${null}", Object.class);
            if (ExpressionTest.equalsTest((Expression)vexp1, null, (StringBuffer)buf)) {
                pass = false;
                buf.append("ValueExpression tested equal to null" + TestUtil.NEW_LINE);
            }
            if (ExpressionTest.equalsTest((Expression)(mexp1 = expFactory.createMethodExpression(context, "null", null, new Class[0])), null, (StringBuffer)buf)) {
                pass = false;
                buf.append("MethodExpression tested equal to null" + TestUtil.NEW_LINE);
            }
            if (ExpressionTest.equalsTest((Expression)(vexp2 = expFactory.createValueExpression(context, "literal", Object.class)), (Expression)(mexp2 = expFactory.createMethodExpression(context, "literal", null, new Class[0])), (StringBuffer)buf)) {
                pass = false;
                buf.append("ValueExpression tested equal to MethodExpression" + TestUtil.NEW_LINE);
            }
            if (ExpressionTest.equalsTest((Expression)mexp2, (Expression)vexp2, (StringBuffer)buf)) {
                pass = false;
                buf.append("MethodExpression tested equal to ValueExpression" + TestUtil.NEW_LINE);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void expressionHashCodeTest() throws Exception {
        MethodExpression mexp2;
        SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = simpleContext.getELContext();
        String exprStr1 = "#{vect.add}";
        Class[] paramTypes1 = new Class[]{Object.class};
        MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1);
        if (!mexp1.equals((Object)(mexp2 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1)))) {
            throw new Exception("Failed: equals check failed!");
        }
        if (mexp1.hashCode() != mexp2.hashCode()) {
            throw new Exception("Failed: hashCode check failed!");
        }
    }
}

