/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.SessionBean;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;

public class TestServlet
extends HttpServlet {
    @Inject
    private Sheep sheep;
    @Resource(name="greeting")
    String greeting;
    String game;
    SessionBean sessionBean;
    EntityManager persistenceContext;
    EntityManagerFactory persistenceUnit;
    private boolean injectionPerformedCorrectly = false;
    private boolean initializerCalled = false;
    private boolean initCalledAfterInitializer = false;
    private boolean initCalledAfterResourceInjection = false;
    private boolean initCalledAfterEJBResourceInjection = false;
    private boolean initCalledAfterPersistenceResourceInjection = false;
    private static final long serialVersionUID = -7672096092047821010L;

    @Inject
    public void initialize(Sheep sheep) {
        this.initializerCalled = sheep != null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().endsWith("Servlet")) {
            this.testServlet(req, resp);
        } else if (req.getRequestURI().endsWith("ServletListener")) {
            this.testListener(req, resp);
        } else if (req.getRequestURI().endsWith("TagLibraryListener")) {
            this.testTagLibraryListener(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    private void testServlet(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            resp.setStatus(this.injectionPerformedCorrectly ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            resp.setStatus(this.initCalledAfterInitializer ? 200 : 500);
        } else if (req.getParameter("test").equals("resource")) {
            resp.setStatus(this.initCalledAfterResourceInjection ? 200 : 500);
        } else if (req.getParameter("test").equals("ejb")) {
            resp.setStatus(this.initCalledAfterEJBResourceInjection ? 200 : 500);
        } else if (req.getParameter("test").equals("persistence")) {
            resp.setStatus(this.initCalledAfterPersistenceResourceInjection ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    private void testListener(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("listener.injected");
            resp.setStatus(result ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("listener.initializer.called");
            resp.setStatus(result ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    private void testTagLibraryListener(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("test").equals("injection")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("tag.library.listener.injected");
            resp.setStatus(result ? 200 : 500);
        } else if (req.getParameter("test").equals("initializer")) {
            boolean result = (Boolean)req.getSession().getServletContext().getAttribute("tag.library.listener.initializer.called");
            resp.setStatus(result ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    public void init() throws ServletException {
        this.injectionPerformedCorrectly = this.sheep != null;
        this.initCalledAfterInitializer = this.initializerCalled;
        this.initCalledAfterResourceInjection = "Hello".equals(this.greeting) && "poker".equals(this.game);
        this.initCalledAfterEJBResourceInjection = this.sessionBean.ping();
        this.initCalledAfterPersistenceResourceInjection = this.persistenceContext != null && this.persistenceUnit != null;
    }

    public void init(ServletConfig config) throws ServletException {
        this.init();
    }

    @Resource(name="game")
    private void setGame(String game) {
        this.game = game;
    }

    @EJB
    private void setSessionBean(SessionBean sessionBean) {
        this.sessionBean = sessionBean;
    }

    @PersistenceContext
    private void setPersistenceContext(EntityManager persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @PersistenceUnit
    private void setPersistenceUnit(EntityManagerFactory persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }
}

