/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.manytomany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.manytomany.Course;
import ee.jakarta.tck.persistence.core.override.manytomany.Student;
import java.util.HashSet;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Integer COURSE1_ID = 203;
    private static final String COURSE1_NAME = "Math";
    private static final Integer COURSE2_ID = 275;
    private static final String COURSE2_NAME = "Science";
    private static final Integer STUDENT1_ID = 12345;
    private static final String STUDENT1_NAME = "Scott";
    private static final Integer STUDENT2_ID = 67890;
    private static final String STUDENT2_NAME = "Jonathan";
    private static final Integer STUDENT3_ID = 24680;
    private static final String STUDENT3_NAME = "Eliot";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "Course", pkgName + "Student"};
        return this.createDeploymentJar("jpa_core_override_manytomany.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception:test failed ", (Throwable)e);
        }
    }

    @Test
    public void testNoManyToManyAnnotation() throws Exception {
        this.getEntityTransaction().begin();
        Course mathCourse = this.createCourse(COURSE1_ID, COURSE1_NAME);
        Course scienceCourse = this.createCourse(COURSE2_ID, COURSE2_NAME);
        Student student1 = this.createStudent(STUDENT1_ID, STUDENT1_NAME);
        student1.addCourse(mathCourse);
        student1.addCourse(scienceCourse);
        Student student2 = this.createStudent(STUDENT2_ID, STUDENT2_NAME);
        student2.addCourse(mathCourse);
        Student student3 = this.createStudent(STUDENT3_ID, STUDENT3_NAME);
        student3.addCourse(scienceCourse);
        HashSet<Student> mathStudents = new HashSet<Student>();
        mathStudents.add(student1);
        mathStudents.add(student2);
        HashSet<Student> scienceStudents = new HashSet<Student>();
        scienceStudents.add(student3);
        scienceStudents.add(student1);
        mathCourse.setStudents(mathStudents);
        scienceCourse.setStudents(scienceStudents);
        this.getEntityManager().persist((Object)mathCourse);
        this.getEntityManager().persist((Object)scienceCourse);
        this.getEntityManager().persist((Object)student1);
        this.getEntityManager().persist((Object)student2);
        this.getEntityManager().persist((Object)student3);
        this.getEntityManager().flush();
        try {
            Course retrieveMath = (Course)this.getEntityManager().find(Course.class, (Object)COURSE1_ID);
            Course retrieveScience = (Course)this.getEntityManager().find(Course.class, (Object)COURSE2_ID);
            if (retrieveMath.getStudents().size() != 2 || retrieveScience.getStudents().size() != 2) {
                throw new Exception("Expected many to many relationship between course and student to have been set. Expected 2 students in Math and 2 in Science, Actual - " + retrieveMath.getStudents().size() + " - " + retrieveScience.getStudents().size());
            }
            logger.log(System.Logger.Level.TRACE, "Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testNoManyToManyAnnotation" + e);
        }
    }

    private Student createStudent(int id, String name) {
        Student student = new Student();
        student.setId(id);
        student.setName(name);
        return student;
    }

    private Course createCourse(int id, String courseName) {
        Course course = new Course();
        course.setId(id);
        course.setName(courseName);
        return course;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COURSE_2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM STUDENT_2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

