/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.callbacklistener;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.callbacklistener.OverridenCallBack;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "OverridenCallBack"};
        String[] xmlFiles = new String[]{"orm.xml"};
        return this.createDeploymentJar("jpa_core_override_callbacklistener.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void postLoad() throws Exception {
        boolean pass3 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
        try {
            pass3 = this.checkLoadCallBacks();
            if (!pass3) {
                throw new Exception("Test failed while testing postLoad method");
            }
            logger.log(System.Logger.Level.TRACE, "testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing postLoad" + e);
        }
    }

    @Test
    public void preAndPostPersist() throws Exception {
        boolean pass1 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
        try {
            pass1 = this.checkPersistCallBacks();
            if (!pass1) {
                throw new Exception("Test failed while testing prepersist and postpersist methods");
            }
            logger.log(System.Logger.Level.TRACE, "testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing preAndPostPersist" + e);
        }
    }

    @Test
    public void preAndPostRemove() throws Exception {
        boolean pass2 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
        logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
        try {
            pass2 = this.checkRemoveCallBacks();
            if (!pass2) {
                throw new Exception("Test failed while testing preremove and postremove methods");
            }
            logger.log(System.Logger.Level.TRACE, "testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing preAndPostRemove" + e);
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersistFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws Exception {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        String thisTestId = callBackName;
        boolean pass = false;
        int count = CallBackCounts.getCount(callBackName);
        if (count == expectedCount) {
            logger.log(System.Logger.Level.TRACE, "test passed in test method" + thisTestId);
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "test failed in test method" + thisTestId);
            logger.log(System.Logger.Level.TRACE, "in CallBackName =" + callBackName);
            logger.log(System.Logger.Level.TRACE, "in expectedCount =" + expectedCount);
            logger.log(System.Logger.Level.TRACE, "in ActualCount =" + count);
        }
        return pass;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

