/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.DID2Employee;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "B", pkgName + "DID2Employee", pkgName + "DID2EmployeeId", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_identifiabletype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected: " + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    @Test
    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
                try {
                    iType.getId(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    @Test
    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.Integer, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    @Test
    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
                try {
                    iType.getVersion(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                logger.log(System.Logger.Level.TRACE, "entityType Name = A");
                SingularAttribute idAttrib = iType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    @Test
    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A IdentifiableType");
                try {
                    iType.getDeclaredId(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + iType.getName());
                SingularAttribute idAttrib = iType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    logger.log(System.Logger.Level.TRACE, "Received:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: value, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntities(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    @Test
    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + iType.getName());
                try {
                    iType.getDeclaredVersion(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntities(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void getSupertype() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.identifiabletype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + iType.getName());
                IdentifiableType idType = iType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "getSuperType() returned:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSupertype failed");
        }
    }

    @Test
    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + iType.getName());
                boolean hasSingleIdAttribute = iType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasSingleIdAttribute);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    @Test
    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + iType.getName());
                boolean hasVersionAttribute = iType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "hasSingleIdAttribute() returned" + hasVersionAttribute);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasVersionAttribute);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    @Test
    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(DID2Employee.class);
            if (iType != null) {
                Set idClassAttribSet = iType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    for (SingularAttribute attrib : idClassAttribSet) {
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    @Test
    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getIdClassAttributes();
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    @Test
    public void getIdType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Type idType = iType.getIdType();
                if (idType != null) {
                    logger.log(System.Logger.Level.TRACE, "idType Name = " + idType.getJavaType());
                    String name = idType.getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected: " + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getIdType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdType failed");
        }
    }

    @Test
    public void getAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Attribute attrib = iType.getAttribute("id");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("id")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: id, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    @Test
    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                try {
                    iType.getAttribute("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    @Test
    public void getAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("id");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("name");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    @Test
    public void getCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClass failed");
        }
    }

    @Test
    public void getCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress");
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionString failed");
        }
    }

    @Test
    public void getCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Attribute attrib = iType.getDeclaredAttribute("cAddress");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("cAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    @Test
    public void getDeclaredAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredAttribute("cAddress_inherited");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClass failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionString failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress", Address.class);
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClass failed");
        }
    }

    @Test
    public void getDeclaredListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress");
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListString failed");
        }
    }

    @Test
    public void getDeclaredListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClass failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited", Address.class, String.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress");
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapString failed");
        }
    }

    @Test
    public void getDeclaredMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress", Address.class);
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClass failed");
        }
    }

    @Test
    public void getDeclaredSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress");
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetString failed");
        }
    }

    @Test
    public void getDeclaredSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value", Integer.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: value, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClass failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name", String.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value");
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: value, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeString failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    @Test
    @Disabled
    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    @Test
    public void getListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress", Address.class);
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClass failed");
        }
    }

    @Test
    public void getListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getList("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress");
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListString failed");
        }
    }

    @Test
    public void getListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClass failed");
        }
    }

    @Test
    public void getMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist", Address.class, String.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress");
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapString failed");
        }
    }

    @Test
    public void getMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    @Test
    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    @Test
    public void getSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress", Address.class);
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClass failed");
        }
    }

    @Test
    public void getSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress");
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sAddress, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetString failed");
        }
    }

    @Test
    public void getSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name", String.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: name, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClass failed");
        }
    }

    @Test
    public void getSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name");
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: name, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeString failed");
        }
    }

    @Test
    public void getSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity A");
                Set set = iType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getSingularAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttributes(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

