/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXmany.B;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_detach_manyXmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detachMXMTest1() throws Exception {
        A aRef = new A("1", "a1", 1);
        B b1 = new B("1", "b1", 1);
        B b2 = new B("2", "b2", 2);
        int foundB = 0;
        String[] expectedResults = new String[]{"1", "2"};
        boolean pass1 = true;
        boolean pass2 = false;
        try {
            logger.log(System.Logger.Level.TRACE, "Begin detachMXMTest1");
            this.createA(aRef);
            logger.log(System.Logger.Level.TRACE, "Call clean to detach");
            this.clearCache();
            this.getEntityTransaction().begin();
            if (!this.getEntityManager().contains((Object)aRef)) {
                logger.log(System.Logger.Level.TRACE, "Status is false as expected, try merge");
                this.getEntityManager().merge((Object)aRef);
                aRef.getBCol().add(b1);
                aRef.getBCol().add(b2);
                this.getEntityManager().merge((Object)aRef);
                logger.log(System.Logger.Level.TRACE, "findA and getBCol");
                A a1 = (A)this.getEntityManager().find(A.class, (Object)"1");
                Collection newCol = a1.getBCol();
                if (newCol.size() != 2) {
                    logger.log(System.Logger.Level.ERROR, "detachMXMTest1: Did not get expected results.Expected Collection Size of 2 B entities, got: " + newCol.size());
                    pass1 = false;
                } else if (pass1) {
                    Iterator i1 = newCol.iterator();
                    block11: while (i1.hasNext()) {
                        logger.log(System.Logger.Level.TRACE, "Check Collection B entities");
                        B c1 = (B)i1.next();
                        for (int l = 0; l < 2; ++l) {
                            if (!expectedResults[l].equals(c1.getBId())) continue;
                            logger.log(System.Logger.Level.TRACE, "Found B Entity : " + c1.getBName());
                            ++foundB;
                            continue block11;
                        }
                    }
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "entity is not detached, cannot proceed with test.");
                pass1 = false;
                pass2 = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception caught during commit:", (Throwable)e);
            pass1 = false;
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (foundB != 2) {
            logger.log(System.Logger.Level.ERROR, "detachMXMTest1: Did not get expected results");
            pass2 = false;
        } else {
            logger.log(System.Logger.Level.TRACE, "Expected results received");
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new Exception("detachMXMTest1 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM FKEYS_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

