/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex1a;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex1a.DID1Dependent;
import ee.jakarta.tck.persistence.core.derivedid.ex1a.DID1DependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex1a.DID1Employee;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID1Dependent", pkgName + "DID1DependentId", pkgName + "DID1Employee"};
        return this.createDeploymentJar("jpa_core_derivedid_ex1a.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID1Employee employee1 = new DID1Employee(1L, "Duke");
            DID1Employee employee2 = new DID1Employee(2L, "foo");
            DID1Dependent dep1 = new DID1Dependent("Obama", employee1);
            DID1Dependent dep2 = new DID1Dependent("Michelle", employee1);
            DID1Dependent dep3 = new DID1Dependent("John", employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            this.getEntityManager().flush();
            for (int i = 1; i < 3; ++i) {
                DID1Employee newEmployee = (DID1Employee)this.getEntityManager().find(DID1Employee.class, (Object)i);
                if (newEmployee == null) continue;
                this.getEntityManager().refresh((Object)newEmployee);
            }
            DID1Dependent newDependent = (DID1Dependent)this.getEntityManager().find(DID1Dependent.class, (Object)new DID1DependentId("Obama", 1L));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID1Dependent d where d.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DTDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

