/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.tableGenerator;

import ee.jakarta.tck.persistence.common.PMClientBase;
import org.junit.jupiter.api.AfterEach;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    protected void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

