/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.harness.ExecutionMode;
import com.sun.ts.lib.harness.TSKeywords;
import com.sun.ts.lib.harness.VehicleVerifier;
import com.sun.ts.lib.util.AssertionMapper;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class TSTestFinder
extends TagTestFinder {
    public static final String TS_HOME;
    protected static final File[] NON_TEST_DIRS;
    protected static final String PARSE_TAG_BAD = "Invalid tag: ";
    private static final String INTEROP_FORWARD = "forward";
    private static final String INTEROP_REVERSE = "reverse";
    private static final String INTEROP_BOTH = "both";
    private static final String SRC_TOKEN;
    private static final String[] defaultVehicles;
    private static final String[] EXCLUDE_NAMES;
    private static final String KEY_CLASS_SETUP_PROPS = "class.setup_props:";
    private static final String KEY_CLASS_TEST_ARGS = "class.testArgs:";
    private static final String KEY_TEST_NAME = "testName:";
    private static final String KEY_TEST_ARGS = "testArgs:";
    private static final String KEY_CUSTOM = "custom:";
    private static final String KEY_TEST_CASE_SETUP_PROPS = "tcase.setup_props:";
    private static final String KEY_ASSERTION_IDS = "assertion_ids:";
    private static final String KEY_KEYWORDS = "keywords:";
    private static final String[] VALID_TAG_NAMES;
    private static final boolean PROCESS_ASSERTION;
    private static final boolean REPORT_MISSING;
    private static final boolean ASSERTION_COVERAGE;
    protected boolean bJCKServiceTest;
    protected String sInteropDirections = "forward";
    protected File appTestDir;
    private static TSKeywords tsKeywords;
    private VehicleVerifier vehicleVerifier;
    private boolean fastScan;
    private int iNumberOfAssertions = 0;
    private String sClass = "";
    private int executionMode = 0;
    public static Hashtable htTestNamesFound;

    public TSTestFinder() {
        Arrays.sort(VALID_TAG_NAMES);
        this.exclude(EXCLUDE_NAMES);
        this.setInitialTag(null);
        try {
            PropertyManagerInterface propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            this.executionMode = ExecutionMode.getExecutionMode(propMgr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scan(File file) {
        for (int i = 0; i < NON_TEST_DIRS.length; ++i) {
            if (file.compareTo(NON_TEST_DIRS[i]) != 0) continue;
            return;
        }
        super.scan(file);
    }

    public static String getAbsolutePath(String testRootPath, String path) {
        return new File(testRootPath, path).getAbsolutePath();
    }

    public static String getAbsolutePath(String path) {
        return TSTestFinder.getAbsolutePath(TS_HOME + "/src", path);
    }

    public static void main(String[] argv) {
        String sRoot = null;
        Vector<TestDescription> vTestDescriptions = new Vector<TestDescription>();
        TestDescription td = null;
        for (int ii = 0; ii < argv.length; ++ii) {
            if (argv[ii].startsWith("-rootdir")) {
                sRoot = argv[++ii];
                continue;
            }
            TestUtil.logHarness("Must supply a rootdir");
            System.exit(-1);
        }
        TestFinderQueue tfq = new TestFinderQueue();
        TSTestFinder tf = new TSTestFinder();
        try {
            tf.init(TestUtil.EMPTY_STRING_ARRAY, new File(sRoot), null);
            tfq.setTestFinder((TestFinder)tf);
            tfq.setTests(new String[]{sRoot});
        }
        catch (Exception e) {
            TestUtil.logHarness("Exception initializing the TestFinder");
            e.printStackTrace();
        }
        while ((td = tfq.next()) != null) {
            vTestDescriptions.addElement(td);
        }
        try {
            tf.writeToFile(vTestDescriptions);
            TestUtil.logHarness("Total # of Assertions = " + tf.iNumberOfAssertions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void processEntry(Map tagValues, String name, String value) {
        if (Arrays.binarySearch(VALID_TAG_NAMES, name) < 0) {
            name = "error";
            value = PARSE_TAG_BAD + name;
        }
        super.processEntry(tagValues, name, (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanFile(File file) {
        String name = file.getName();
        if (!name.endsWith(".java") || name.equals("BaseUIComponentClient.java") || name.equals("DataModelURLClient.java")) {
            return;
        }
        int dot = name.indexOf(46);
        if (dot == 0) {
            return;
        }
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("Scanning " + name);
        }
        String sVal = null;
        String extn = name.substring(dot);
        Class csc = this.getClassForExtension(extn);
        if (csc == null) {
            String[] msgs = new String[]{"no parser found for specified file", "file: " + file, "extension: " + extn};
            TestUtil.logErr(msgs[0] + msgs[1] + msgs[2]);
            return;
        }
        CommentStream cs = null;
        try {
            cs = (CommentStream)csc.newInstance();
        }
        catch (InstantiationException e) {
            String[] msgs = new String[]{"problem instantiating class for extension", "extension: " + extn, "class: " + csc.getName()};
            TestUtil.logErr(msgs[0] + msgs[1] + msgs[2]);
            return;
        }
        catch (IllegalAccessException e) {
            String[] msgs = new String[]{"illegal access while instantiating class for extension", "extension: " + extn, "class: " + csc.getName()};
            TestUtil.logErr(msgs[0] + msgs[1] + msgs[2]);
            return;
        }
        try {
            String comment;
            cs.init(new BufferedReader(new FileReader(file)));
            if (this.fastScan) {
                cs.setFastScan(true);
            }
            Map propTags = new Hashtable();
            while ((comment = cs.readComment()) != null) {
                Map myTagValues = this.parseComment(comment, file);
                if (myTagValues.isEmpty()) continue;
                if (myTagValues.containsKey(KEY_CLASS_SETUP_PROPS) || myTagValues.containsKey(KEY_CLASS_TEST_ARGS)) {
                    propTags = myTagValues;
                    continue;
                }
                if (!myTagValues.containsKey(KEY_TEST_NAME)) continue;
                myTagValues.put("testdirectory", file.getPath());
                if (!propTags.isEmpty()) {
                    sVal = (String)propTags.get(KEY_CLASS_SETUP_PROPS);
                    if (sVal != null) {
                        myTagValues.put(KEY_CLASS_SETUP_PROPS, sVal);
                    }
                    if ((sVal = (String)propTags.get(KEY_CLASS_TEST_ARGS)) != null) {
                        myTagValues.put(KEY_CLASS_TEST_ARGS, sVal);
                    }
                }
                this.foundTestDescription(myTagValues, file, 0);
            }
        }
        catch (FileNotFoundException e) {
            String msgs = "can't find file " + file.getPath();
            e.printStackTrace();
            TestUtil.logErr(msgs);
        }
        catch (IOException e) {
            String msgs = "problem reading file " + file.getPath();
            e.printStackTrace();
            TestUtil.logErr(msgs);
            this.error(null, msgs);
        }
        catch (Throwable e) {
            String msgs = "got exception: problem reading file " + file.getPath();
            e.printStackTrace();
            TestUtil.logErr(msgs);
        }
        finally {
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (IOException e) {
                TestUtil.logErr(e.getMessage());
            }
        }
    }

    protected void foundTestDescription(Map entries, File file, int line) {
        String[] sVal = null;
        TestDescription td = null;
        if (!entries.isEmpty()) {
            this.vehicleVerifier = VehicleVerifier.getInstance(file, (String)entries.get(KEY_TEST_NAME));
            sVal = this.vehicleVerifier.getVehicleSet();
            if (sVal.length > 0) {
                for (int ii = 0; ii < sVal.length; ++ii) {
                    if (this.sInteropDirections.equals(INTEROP_FORWARD) || this.sInteropDirections.equals(INTEROP_BOTH)) {
                        td = this.createTestDescription(entries, file, sVal[ii].trim(), false);
                        this.foundTestDescription(td);
                    }
                    if (!this.sInteropDirections.equals(INTEROP_REVERSE) && !this.sInteropDirections.equals(INTEROP_BOTH)) continue;
                    td = this.createTestDescription(entries, file, sVal[ii].trim(), true);
                    this.foundTestDescription(td);
                }
            } else {
                if (this.sInteropDirections.equals(INTEROP_FORWARD) || this.sInteropDirections.equals(INTEROP_BOTH)) {
                    td = this.createTestDescription(entries, file, null, false);
                    this.foundTestDescription(td);
                }
                if (this.sInteropDirections.equals(INTEROP_REVERSE) || this.sInteropDirections.equals(INTEROP_BOTH)) {
                    td = this.createTestDescription(entries, file, null, true);
                    this.foundTestDescription(td);
                }
            }
        }
    }

    private void writeToFile(Vector v) throws IOException {
        TestDescription td = null;
        FileWriter fw = new FileWriter("test_report.txt");
        int iSize = v.size();
        for (int ii = 0; ii < iSize; ++ii) {
            td = (TestDescription)v.elementAt(ii);
            this.writeTest(td, fw);
        }
        fw.close();
    }

    private void writeTest(TestDescription td, FileWriter fw) throws IOException {
        String sName = td.getParameter("testName");
        String sAssertion = td.getParameter("assertion_ids");
        String sLastClass = this.sClass;
        this.sClass = td.getParameter("classname");
        this.sClass = this.sClass.substring(0, this.sClass.lastIndexOf(46));
        if (!this.sClass.equals(sLastClass)) {
            fw.write(this.sClass + "\tTests" + TestUtil.NEW_LINE + TestUtil.NEW_LINE);
        }
        fw.write("Test:\t" + sName + TestUtil.NEW_LINE);
        fw.write("Assertion:\t" + sAssertion + TestUtil.NEW_LINE);
        fw.write(TestUtil.NEW_LINE);
        ++this.iNumberOfAssertions;
    }

    private String[] getDefaultVehicles() {
        return defaultVehicles;
    }

    private TestDescription createTestDescription(Map tags, File file, String sVehicle, boolean bReverse) {
        Vector<String> propv = new Vector<String>();
        Object sval = null;
        String fn = file.getName();
        String key2 = null;
        String cls = fn.substring(0, fn.indexOf(46));
        String fullclass = this.getPkgName(file) + "." + cls;
        Hashtable<String, Object> desc = new Hashtable<String, Object>();
        desc.put("classname", fullclass);
        String test_dir = null;
        if (this.bJCKServiceTest) {
            desc.put("finder", "jck");
            test_dir = this.appTestDir.getAbsolutePath();
        } else {
            desc.put("finder", "cts");
            test_dir = file.getParent();
        }
        desc.put("test_directory", TestUtil.getRelativePath(test_dir));
        for (String key2 : tags.keySet()) {
            if (key2.equals(KEY_TEST_NAME)) {
                sval = (String)tags.get(key2);
                if (sval != null) {
                    sval = ((String)sval).trim();
                }
                if (htTestNamesFound.containsKey(file.getPath() + "#" + (String)sval)) {
                    Integer iCount = (Integer)htTestNamesFound.get(file.getPath() + "#" + (String)sval);
                    htTestNamesFound.put(file.getPath() + "#" + (String)sval, new Integer(iCount + 1));
                } else {
                    htTestNamesFound.put(file.getPath() + "#" + (String)sval, new Integer(1));
                }
                if (sVehicle != null) {
                    sval = (String)sval + "_from_" + sVehicle;
                    desc.put("service_eetest", "yes");
                } else {
                    desc.put("service_eetest", "no");
                }
                if (bReverse) {
                    sval = (String)sval + "_reverse";
                    desc.put("direction", INTEROP_REVERSE);
                } else {
                    desc.put("direction", INTEROP_FORWARD);
                }
                desc.put("id", sval);
            }
            if (key2.equals(KEY_TEST_NAME) || key2.equals(KEY_CUSTOM)) {
                sval = (String)tags.get(key2);
                if (sval != null) {
                    sval = ((String)sval).trim();
                }
                key2 = key2.substring(0, key2.indexOf(58));
                desc.put(key2, sval);
            } else if (key2.equals(KEY_ASSERTION_IDS) && PROCESS_ASSERTION) {
                sval = (String)tags.get(key2);
                if (sval != null) {
                    sval = ((String)sval).trim();
                }
                key2 = key2.substring(0, key2.indexOf(58));
                if (ASSERTION_COVERAGE) {
                    desc.put(key2, sval);
                } else {
                    desc.put(key2, AssertionMapper.getAssertionDescriptions((String)sval, file));
                }
            } else if (key2.equals(KEY_CLASS_TEST_ARGS) || key2.equals(KEY_TEST_ARGS)) {
                String sCurrentArgs = (String)desc.get("testArgs");
                sval = (String)tags.get(key2);
                if (sval == null) continue;
                sval = ((String)sval).trim();
                key2 = key2.substring(0, key2.indexOf(58));
                if (sCurrentArgs == null) {
                    desc.put("testArgs", sval);
                } else {
                    desc.put("testArgs", sCurrentArgs + " " + (String)sval);
                }
            } else if (key2.equals(KEY_KEYWORDS)) {
                sval = (String)tags.get(key2);
                if (sval != null) {
                    sval = ((String)sval).trim();
                }
                key2 = key2.substring(0, key2.indexOf(58));
                desc.put(key2, sval);
            }
            if (key2.equals(KEY_CLASS_SETUP_PROPS) || key2.equals(KEY_TEST_CASE_SETUP_PROPS)) {
                sval = (String)tags.get(key2);
                TestUtil.logHarnessDebug("KEY_TEST_CASE_SETUP_PROPS sval \"" + (String)sval + "\"");
                if (sval == null) continue;
                if (!((String)(sval = ((String)sval).trim())).endsWith(";")) {
                    sval = (String)sval + ";";
                }
                TestUtil.logHarnessDebug("KEY_TEST_CASE_SETUP_PROPS normalized sval \"" + (String)sval + "\"");
                int sl = ((String)sval).length() - 1;
                int start = 0;
                int count = 1;
                int sep = 0;
                int sep2 = 0;
                while (count < sl) {
                    sep = ((String)sval).indexOf(59);
                    if (sep == -1) continue;
                    String propdesc = ((String)sval).substring(start, sep);
                    sval = ((String)sval).substring(sep + 1);
                    sep2 = propdesc.indexOf(44);
                    if (sep2 != -1) {
                        propdesc = propdesc.substring(0, sep2);
                    }
                    propv.addElement(propdesc);
                    count += sep + 1;
                }
            }
            Object s1 = "";
            int size = propv.size();
            for (int j = 0; j < size; ++j) {
                s1 = (String)s1 + " " + propv.elementAt(j);
            }
            desc.put("testProps", s1);
        }
        Object sKeywords = (String)desc.get("keywords");
        if (sKeywords != null) {
            sKeywords = ((String)sval).trim() + " " + (String)sKeywords;
            sKeywords = (String)sKeywords + " ";
        } else {
            sKeywords = "";
        }
        sKeywords = (String)sKeywords + "all ";
        tsKeywords = TSKeywords.getInstance(file);
        String[] sKeywordsFromProperties = tsKeywords.getKeywordSet();
        for (int ii = 0; ii < sKeywordsFromProperties.length; ++ii) {
            if (sKeywordsFromProperties[ii].contains("web_profile") && sVehicle != null) {
                if (!sVehicle.contains("web") && !sVehicle.contains("servlet") && !sVehicle.contains("jsp") && !sVehicle.contains("ejbembed") && !sVehicle.contains("ejblite") && !sVehicle.contains("jsf") || sVehicle.contains("puservlet")) continue;
                sKeywords = (String)sKeywords + sKeywordsFromProperties[ii] + " ";
                continue;
            }
            sKeywords = (String)sKeywords + sKeywordsFromProperties[ii] + " ";
        }
        sKeywords = (String)sKeywords + desc.get("testName") + " ";
        sKeywords = sVehicle != null ? (String)sKeywords + sVehicle + "_vehicle " : (String)sKeywords + "novehicle ";
        sKeywords = bReverse ? (String)sKeywords + INTEROP_REVERSE : (String)sKeywords + INTEROP_FORWARD;
        desc.put("keywords", sKeywords);
        TestUtil.logHarnessDebug("Keywords for this test, " + (String)tags.get(KEY_TEST_NAME) + ", are:  " + (String)sKeywords);
        if (REPORT_MISSING && !desc.containsKey("assertion_ids")) {
            AssertionMapper.log("WARN: missing assertion_ids tag in testName " + desc.get("testName") + " in file " + file.getPath());
        }
        File root = this.getRoot();
        return new TestDescription(root, file, desc);
    }

    private String getPkgName(File clientFile) {
        String result = null;
        String clientFileDir = clientFile.getParent();
        int i = clientFileDir.indexOf(SRC_TOKEN);
        if (i != -1) {
            result = clientFileDir.substring(i + 5);
            result = result.replace(File.separatorChar, '.');
        } else {
            result = this.getPkgName2(clientFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPkgName2(File tfile) {
        String pkgName = null;
        String line = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(tfile));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || !line.startsWith("package") || !line.endsWith(";")) continue;
                int pkgstart = line.indexOf(32);
                pkgName = line.substring(pkgstart, line.indexOf(59));
                String string = pkgName.trim();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return pkgName;
    }

    static {
        SRC_TOKEN = File.separator + "src" + File.separator;
        defaultVehicles = new String[]{"ejb", "servlet", "jsp", "appclient"};
        EXCLUDE_NAMES = new String[]{"SCCS", "Codemgr_wsdata", "DeletedFiles", "DELETED-FILES", "deleted_files", "TemporarilyRemoved", "ts_dep"};
        VALID_TAG_NAMES = new String[]{KEY_CLASS_SETUP_PROPS, KEY_CLASS_TEST_ARGS, KEY_TEST_NAME, KEY_TEST_ARGS, KEY_CUSTOM, KEY_TEST_CASE_SETUP_PROPS, KEY_ASSERTION_IDS, KEY_KEYWORDS};
        TS_HOME = System.getProperty("TS_HOME");
        PROCESS_ASSERTION = Boolean.getBoolean("process.assertion");
        REPORT_MISSING = Boolean.getBoolean("report.missing.assertion.ids.tag");
        ASSERTION_COVERAGE = Boolean.getBoolean("assertion.coverage");
        NON_TEST_DIRS = new File[]{new File(TS_HOME, "src/web"), new File(TS_HOME, "src/org/omg/stub"), new File(TS_HOME, "src/com/sun/ts/lib"), new File(TS_HOME, "src/com/sun/ts/tests/common")};
        htTestNamesFound = new Hashtable();
    }
}

