/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.dates;

import ee.jakarta.tck.json.bind.MappingTester;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.CalendarContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.DateContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.DurationContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.GregorianCalendarContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.InstantContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.LocalDateContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.LocalDateTimeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.LocalTimeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.OffsetDateTimeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.OffsetTimeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.PeriodContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.SimpleTimeZoneContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.TimeZoneContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.ZoneIdContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.ZoneOffsetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.dates.model.ZonedDateTimeContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.function.BiPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DatesMappingTest {
    private static final String OFFSET_HOURS = DatesMappingTest.getHoursFromUTCRegExp(new GregorianCalendar(1970, 0, 1));

    private <T extends TimeZone> BiPredicate<T, T> timezoneTest(boolean canBeSaving) {
        return (a, b) -> {
            long diff = Math.abs(a.getRawOffset() - b.getRawOffset());
            return a.useDaylightTime() && canBeSaving ? diff == 0L || diff == (long)a.getDSTSavings() : diff == 0L;
        };
    }

    @Test
    public void testDate() {
        Date date = new Date(70, 0, 1);
        Jsonb jsonb = JsonbBuilder.create();
        String json = jsonb.toJson(jsonb.fromJson(jsonb.toJson((Object)date), Date.class));
        Date mixin = (Date)jsonb.fromJson(json, Date.class);
        MatcherAssert.assertThat((String)"Serializing and deserializing Date results in different value", (Object)mixin, (Matcher)Matchers.is((Object)date));
    }

    @Test
    public void testDateNoTimeMapping() {
        Date date = new Date(70, 0, 1);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String toMatch = dtf.format(calendar.toZonedDateTime()).replace("]", "\\]").replace("[", "\\[").replace("+", "\\+");
        new MappingTester(DateContainer.class).setMarshallExpectedRegExp("\"" + toMatch + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.equals(orig.getTime());
        }).test(date, "\"1970-01-01T00:00:00\"");
    }

    @Test
    public void testCalendarNoTimeMapping() {
        Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.clear();
        new MappingTester(CalendarContainer.class).setMarshallExpectedRegExp("\"1970-01-01" + OFFSET_HOURS + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.getTime().equals(orig.getTime()) && DatesMappingTest.getHoursFromUTC(orig).equals(DatesMappingTest.getHoursFromUTC(b));
        }).test(calendarProperty, "\"1970-01-01\"");
    }

    @Test
    public void testGregorianCalendarNoTimeMapping() {
        GregorianCalendar calendar = new GregorianCalendar(1970, 0, 1);
        for (int i = 6; i != 15; ++i) {
            calendar.clear(i);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE;
        String toMatch = "\"" + dtf.format(calendar.toZonedDateTime()).replace("+", "\\+") + "\"";
        new MappingTester(GregorianCalendarContainer.class).setMarshallExpectedRegExp(toMatch).setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.getTime().equals(orig.getTime()) && DatesMappingTest.getHoursFromUTC(orig).equals(DatesMappingTest.getHoursFromUTC(b));
        }).test(calendar, "\"1970-01-01\"");
    }

    @Test
    public void testDateWithTimeMapping() {
        Date date = new Date(70, 0, 1, 0, 0, 0);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String toMatch = dtf.format(calendar.toZonedDateTime()).replace("]", "\\]").replace("[", "\\[");
        new MappingTester(DateContainer.class).setMarshallExpectedRegExp("\"" + toMatch + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.equals(orig.getTime());
        }).test(date, "\"1970-01-01T00:00:00\"");
    }

    @Test
    public void testCalendarWithTimeMapping() {
        Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.set(1970, 0, 1, 1, 0, 0);
        calendarProperty.set(14, 0);
        calendarProperty.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        new MappingTester(CalendarContainer.class).setMarshallExpectedRegExp("\"1970-01-01T01:00:00(\\.\\d{1,3})?\\+01:00\\[Europe/Paris\\]\"").setUnmarshallTestPredicate((a, b) -> a.getTime().equals(b.getTime()) && DatesMappingTest.getHoursFromUTC(calendarProperty).equals(DatesMappingTest.getHoursFromUTC(b))).test(calendarProperty, "\"1970-01-01T01:00:00.00+01:00[Europe/Paris]\"");
    }

    @Test
    @Disabled(value="See: https://github.com/eclipse-ee4j/jakartaee-tck/issues/102")
    public void testGregorianCalendarWithTimeMapping() {
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.of(LocalDateTime.of(1970, Month.FEBRUARY, 1, 1, 0, 0), ZoneId.of("GMT")));
        new MappingTester<GregorianCalendar>(GregorianCalendarContainer.class).test(calendar, "\"1970-01-01T01:00:00Z[GMT]\"");
    }

    @Test
    public void testShortTimeZoneMapping() {
        new MappingTester(TimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(false)).test(TimeZone.getTimeZone("GMT+10"), "\"GMT+10:00\"");
    }

    @Test
    public void testLongTimeZoneMapping() {
        new MappingTester(TimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(true)).test(TimeZone.getTimeZone("America/Los_Angeles"), "\"America/Los_Angeles\"");
    }

    @Test
    public void testSimpleTimeZoneMapping() {
        new MappingTester(SimpleTimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(false)).test(new SimpleTimeZone(4500000, "GMT+01:15"), "\"GMT+01:15\"");
    }

    @Test
    public void testInstantMapping() {
        new MappingTester<Instant>(InstantContainer.class).test(Instant.ofEpochMilli(0L), "\"1970-01-01T00:00:00Z\"");
    }

    @Test
    public void testDurationMapping() {
        new MappingTester<Duration>(DurationContainer.class).test(Duration.ofHours(1L), "\"PT1H\"");
    }

    @Test
    public void testDurationWithSecondsMapping() {
        new MappingTester<Duration>(DurationContainer.class).test(Duration.ofHours(1L).plus(Duration.ofSeconds(1L)), "\"PT1H1S\"");
    }

    @Test
    public void testPeriodMapping() {
        new MappingTester<Period>(PeriodContainer.class).test(Period.of(1, 1, 1), "\"P1Y1M1D\"");
    }

    @Test
    public void testZeroDaysPeriodMapping() {
        new MappingTester<Period>(PeriodContainer.class).test(Period.of(0, 0, 0), "\"P0D\"");
    }

    @Test
    public void testLocalDateMapping() {
        new MappingTester<LocalDate>(LocalDateContainer.class).test(LocalDate.of(2000, 1, 1), "\"2000-01-01\"");
    }

    @Test
    public void testLocalTimeMapping() {
        new MappingTester<LocalTime>(LocalTimeContainer.class).test(LocalTime.of(1, 1, 1), "\"01:01:01\"");
    }

    @Test
    public void testLocalDateTimeMapping() {
        new MappingTester<LocalDateTime>(LocalDateTimeContainer.class).test(LocalDateTime.of(2000, 1, 1, 1, 1, 1), "\"2000-01-01T01:01:01\"");
    }

    @Test
    public void testZonedDateTimeMapping() {
        new MappingTester<ZonedDateTime>(ZonedDateTimeContainer.class).test(ZonedDateTime.of(2000, 1, 1, 1, 1, 1, 0, ZoneId.of("Europe/Paris")), "\"2000-01-01T01:01:01+01:00[Europe/Paris]\"");
    }

    @Test
    public void testZoneIdMapping() {
        new MappingTester<ZoneId>(ZoneIdContainer.class).test(ZoneId.of("UTC"), "\"UTC\"");
    }

    @Test
    public void testZoneOffsetMapping() {
        new MappingTester<ZoneOffset>(ZoneOffsetContainer.class).test(ZoneOffset.of("+01:00"), "\"+01:00\"");
    }

    @Test
    public void testOffsetDateTimeMapping() {
        new MappingTester<OffsetDateTime>(OffsetDateTimeContainer.class).test(OffsetDateTime.of(LocalDateTime.of(2000, 1, 1, 1, 1, 1), ZoneOffset.of("+01:00")), "\"2000-01-01T01:01:01+01:00\"");
    }

    @Test
    public void testOffsetTimeMapping() {
        new MappingTester<OffsetTime>(OffsetTimeContainer.class).test(OffsetTime.of(LocalTime.of(1, 1, 1), ZoneOffset.of("+01:00")), "\"01:01:01+01:00\"");
    }

    @Test
    public void testUnmarshallingUnknownFormat() {
        Assertions.assertThrows(JsonbException.class, () -> JsonbBuilder.create().fromJson("{ \"instance\" : \"01/01/1970 00:00:00\" }", DateContainer.class), (String)"An exception is expected if the date/time string does not correspond to the expected datetime format.");
    }

    @Test
    public void testUnmarshallingDeprecatedTimezoneIds() {
        Jsonb jsonb = JsonbBuilder.create();
        Assertions.assertThrows(JsonbException.class, () -> jsonb.fromJson("{ \"instance\" : \"CST\" }", TimeZoneContainer.class), (String)"An exception is expected for deprecated three-letter time zone IDs.");
        Assertions.assertThrows(JsonbException.class, () -> jsonb.fromJson("{ \"instance\" : \"CST\" }", SimpleTimeZoneContainer.class), (String)"An exception is expected for deprecated three-letter time zone IDs.");
    }

    private static String getHoursFromUTCRegExp(Calendar calendar) {
        String hours = DatesMappingTest.getHoursFromUTC(calendar);
        if ("+00:00".equals(hours)) {
            return "(Z|\\+00:00)";
        }
        return "\\" + hours;
    }

    private static String getHoursFromUTC(Calendar calendar) {
        int offsetInTenMins = DatesMappingTest.getMinutesFromUTC(calendar);
        String offset = String.format("%s%02d:%02d", offsetInTenMins >= 0 ? "+" : "-", Math.abs(offsetInTenMins / 60), Math.abs(offsetInTenMins % 60));
        return offset;
    }

    private static int getMinutesFromUTC(Calendar calendar) {
        TimeZone tz = TimeZone.getDefault();
        Calendar def = (Calendar)calendar.clone();
        def.get(10);
        return tz.getOffset(def.getTimeInMillis()) / 60000;
    }
}

