/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.config.BuilderImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigProvider;
import io.helidon.config.ConfigSources;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.OverrideSources;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class EmptyConfig {
    static final Config.Key ROOT_KEY = new KeyImpl(null, "");
    static final Config EMPTY = new EmptyNode(ROOT_KEY);

    private EmptyConfig() {
    }

    private static final class KeyImpl
    implements Config.Key {
        private final Config.Key parent;
        private final String name;

        private KeyImpl(Config.Key parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        public Config.Key parent() throws ConfigException {
            if (this.isRoot()) {
                throw new IllegalStateException("Attempting to get parent of a root node. Guard by isRoot instead");
            }
            return this.parent;
        }

        @Override
        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Config.Key child(Config.Key key) {
            if (this.isRoot()) {
                return new ConfigProvider.CommonKeyWrapper(key);
            }
            List<String> path = KeyImpl.path(new ConfigProvider.CommonKeyWrapper(key));
            KeyImpl node = this;
            for (String name : path) {
                node = new KeyImpl(node, name);
            }
            return node;
        }

        @Override
        public int compareTo(Config.Key o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public String toString() {
            return String.join((CharSequence)".", KeyImpl.path(this));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyImpl key = (KeyImpl)o;
            return Objects.equals(this.parent, key.parent) && Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name);
        }

        private static List<String> path(Config.Key key) {
            ArrayList<String> names = new ArrayList<String>();
            Config.Key node = key;
            while (!node.isRoot()) {
                names.add(node.name());
                node = node.parent();
            }
            Collections.reverse(names);
            return names;
        }
    }

    private static final class EmptyNode
    implements Config {
        private static final Config DELEGATE = new BuilderImpl().sources((Supplier<? extends ConfigSource>)ConfigSources.empty()).overrides((Supplier<? extends OverrideSource>)OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableParserServices().disableFilterServices().changesExecutor(command -> {}).build();
        private final Config.Key key;

        private EmptyNode(Config.Key key) {
            this.key = key;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        @Override
        public Config root() {
            return EMPTY;
        }

        @Override
        public Config get(Config.Key key) throws ConfigException {
            return new EmptyNode(this.key.child(key));
        }

        @Override
        public Config get(String key) throws ConfigException {
            String[] split = key.split("\\.");
            Config.Key node = this.key;
            for (String s : split) {
                node = new KeyImpl(node, s);
            }
            return new EmptyNode(node);
        }

        @Override
        public Config detach() throws ConfigException {
            return EMPTY;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public <T> ConfigValue<T> as(Class<T> type) {
            return ConfigValues.empty();
        }

        public <T> ConfigValue<T> map(Function<io.helidon.common.config.Config, T> mapper) {
            return ConfigValues.empty();
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigException {
            return ConfigValues.empty();
        }

        public <T> ConfigValue<List<T>> mapList(Function<io.helidon.common.config.Config, T> mapper) throws ConfigException {
            return ConfigValues.empty();
        }

        @Override
        public ConfigValue<List<Config>> asNodeList() throws ConfigException {
            return ConfigValues.empty();
        }

        @Override
        public ConfigValue<Map<String, String>> asMap() throws ConfigException {
            return ConfigValues.empty();
        }

        @Override
        public Instant timestamp() {
            return DELEGATE.timestamp();
        }

        @Override
        public Config.Type type() {
            return Config.Type.MISSING;
        }

        @Override
        public Stream<Config> traverse(Predicate<Config> predicate) {
            return Stream.empty();
        }

        @Override
        public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
            return DELEGATE.convert(type, value);
        }

        @Override
        public ConfigMapper mapper() {
            return DELEGATE.mapper();
        }

        @Override
        public <T> ConfigValue<T> as(GenericType<T> genericType) {
            return ConfigValues.empty();
        }

        @Override
        public <T> ConfigValue<T> as(Function<Config, T> mapper) {
            return ConfigValues.empty();
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
            return ConfigValues.empty();
        }
    }
}

