/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.CommandLine;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.OS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public abstract class GFLauncher {
    private static final System.Logger LOG = System.getLogger(GFLauncher.class.getName());
    private LaunchType mode = LaunchType.normal;
    private final GFLauncherInfo parameters;
    private CommandLine commandLine;
    private long startTime;
    private Process glassFishProcess;
    private ProcessStreamDrainer processStreamDrainer;
    private int exitValue = -1;

    protected GFLauncher(GFLauncherInfo parameters) {
        this.parameters = parameters;
    }

    public abstract Long getPidBeforeRestart();

    public abstract void setup() throws GFLauncherException, MiniXmlParserException;

    public abstract File getAdminRealmKeyFile();

    public abstract boolean isSecureAdminEnabled();

    public abstract Path getLogFile();

    public abstract Integer getDebugPort();

    public abstract boolean isSuspendEnabled();

    public abstract boolean needsAutoUpgrade();

    public abstract boolean needsManualUpgrade();

    public final GFLauncherInfo getParameters() {
        return this.parameters;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final Process getProcess() {
        if (this.glassFishProcess == null) {
            throw new IllegalStateException("Process was not started yet!");
        }
        return this.glassFishProcess;
    }

    public final ProcessStreamDrainer getProcessStreamDrainer() {
        if (this.processStreamDrainer == null) {
            throw new IllegalStateException("Call to getProcessStreamDrainer() before it has been initialized!");
        }
        return this.processStreamDrainer;
    }

    public final void launch() throws GFLauncherException {
        this.logCommandLine();
        try {
            this.startTime = System.currentTimeMillis();
            if (this.isFakeLaunch()) {
                return;
            }
            this.launchInstance();
            if (this.parameters.isVerboseOrWatchdog()) {
                this.exitValue = this.waiForExit(this.glassFishProcess);
            }
        }
        catch (GFLauncherException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GFLauncherException(e);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    public final CommandLine getCommandLine() {
        return this.commandLine;
    }

    protected final void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    final long getStartTime() {
        return this.startTime;
    }

    private void launchInstance() throws GFLauncherException {
        List<String> securityTokens = this.parameters.getSecurityTokens();
        List<String> cmds = this.createCommand(!securityTokens.isEmpty());
        LOG.log(System.Logger.Level.DEBUG, () -> "Executing: " + cmds.stream().collect(Collectors.joining(" ")));
        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        if (this.parameters.isVerboseOrWatchdog()) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        processBuilder.directory(this.parameters.getConfigDir());
        try {
            GFLauncherLogger.removeLogFileHandler();
            this.glassFishProcess = processBuilder.start();
            String name = this.parameters.getDomainName();
            this.processStreamDrainer = this.parameters.isIgnoreOutput() ? ProcessStreamDrainer.dispose((String)name, (Process)this.glassFishProcess) : (this.parameters.isVerbose() ? ProcessStreamDrainer.redirect((String)name, (Process)this.glassFishProcess) : (this.parameters.isWatchdog() ? ProcessStreamDrainer.dispose((String)name, (Process)this.glassFishProcess) : ProcessStreamDrainer.save((String)name, (Process)this.glassFishProcess)));
            GFLauncher.handleDeadProcess(this.glassFishProcess, this.processStreamDrainer);
            if (!securityTokens.isEmpty()) {
                GFLauncher.writeSecurityTokens(this.glassFishProcess, this.processStreamDrainer, securityTokens);
            }
        }
        catch (Exception e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
    }

    private List<String> createCommand(boolean securityTokensAvailable) throws GFLauncherException {
        ArrayList<String> cmds;
        if (OS.isDarwin() && GFLauncher.useLaunchCtl(System.getProperty("os.version")) && !this.parameters.isVerboseOrWatchdog()) {
            cmds = new ArrayList<String>();
            cmds.add("launchctl");
            cmds.add("bsexec");
            cmds.add("/");
            cmds.addAll(this.commandLine.toList());
        } else if (this.commandLine.getFormat() == CommandLine.CommandFormat.Script) {
            cmds = GFLauncher.prepareWindowsEnvironment(this.commandLine, this.parameters.getConfigDir().toPath(), securityTokensAvailable);
        } else if (this.parameters.isVerboseOrWatchdog()) {
            cmds = new ArrayList();
            cmds.addAll(this.commandLine.toList());
        } else {
            cmds = new ArrayList();
            if (!GFLauncher.isWindows()) {
                cmds.add("nohup");
            }
            cmds.addAll(this.commandLine.toList());
        }
        return cmds;
    }

    private void logCommandLine() {
        if (!this.isFakeLaunch()) {
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00005", this.commandLine.toString("\n"));
        }
    }

    private int waiForExit(Process p) throws GFLauncherException {
        try {
            p.waitFor();
            return p.exitValue();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private static boolean useLaunchCtl(String osversion) {
        int major = 0;
        int minor = 0;
        if (osversion == null || osversion.isEmpty()) {
            return false;
        }
        String[] split = osversion.split("[\\._\\-]+");
        try {
            if (split.length > 0 && split[0].length() > 0) {
                major = Integer.parseInt(split[0]);
            }
            if (split.length > 1 && split[1].length() > 0) {
                minor = Integer.parseInt(split[1]);
            }
            return major <= 9 || major <= 10 && minor < 10;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private static List<String> prepareWindowsEnvironment(CommandLine command, Path configDir, boolean stdinPreloaded) throws GFLauncherException {
        try {
            Path startPsFile = GFLauncher.createStartPsScript(command, configDir, stdinPreloaded);
            Path schedulerPsFile = GFLauncher.createSchedulerPsScript(startPsFile, configDir, stdinPreloaded);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("powershell.exe");
            if (stdinPreloaded) {
                cmds.add("-noninteractive");
            }
            cmds.add("-File");
            cmds.add("\"" + String.valueOf(schedulerPsFile) + "\"");
            return cmds;
        }
        catch (IOException e) {
            throw new GFLauncherException(e);
        }
    }

    private static Path createSchedulerPsScript(Path startPsFile, Path configDir, boolean stdinPreloaded) throws IOException {
        StringBuilder schedulerFileContent = new StringBuilder(8192);
        schedulerFileContent.append("$ErrorActionPreference = \"Stop\"\n\n");
        schedulerFileContent.append("$pidFile = \"").append(new File(configDir.toFile(), "pid").getAbsolutePath()).append("\"\n");
        schedulerFileContent.append("if (Test-Path $pidFile) {\n");
        schedulerFileContent.append("    Remove-Item $pidFile -Force\n");
        schedulerFileContent.append("}\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("$stdin = [System.IO.StreamReader]::new([Console]::OpenStandardInput()).ReadToEnd()\n");
            schedulerFileContent.append("$tempFile = [System.IO.Path]::GetTempFileName()\n");
            schedulerFileContent.append("[System.IO.File]::WriteAllText($tempFile, $stdin)\n");
        }
        schedulerFileContent.append("$action = New-ScheduledTaskAction -Execute \"powershell.exe\" -Argument \"-File `\"").append(startPsFile).append("`\" `\"$tempFile`\"\"\n");
        schedulerFileContent.append("$taskName = \"GlassFishInstance_\" + [System.Guid]::NewGuid().ToString()\n");
        schedulerFileContent.append("$trigger = New-ScheduledTaskTrigger -Once -At (Get-Date).AddSeconds(1)\n");
        schedulerFileContent.append("$principal = New-ScheduledTaskPrincipal -UserId $env:USERNAME -LogonType S4U\n");
        schedulerFileContent.append("$settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -ExecutionTimeLimit (New-TimeSpan -Hours 0)\n");
        schedulerFileContent.append("Register-ScheduledTask -TaskName $taskName -Action $action -Trigger $trigger -Principal $principal -Settings $settings\n");
        schedulerFileContent.append("Start-ScheduledTask -TaskName $taskName\n");
        schedulerFileContent.append("Unregister-ScheduledTask -TaskName $taskName -Confirm:$false\n");
        schedulerFileContent.append("$start = Get-Date\n");
        schedulerFileContent.append("$timeout = 60\n");
        schedulerFileContent.append("while (-not (Test-Path $pidFile)) {\n");
        schedulerFileContent.append("    if ((New-TimeSpan -Start $start -End (Get-Date)).TotalSeconds -gt $timeout) {\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("        Remove-Item $tempFile -Force\n");
        }
        schedulerFileContent.append("        Write-Error \"Timeout waiting for GlassFish to start (pid file not created within $timeout seconds)\"\n");
        schedulerFileContent.append("        exit 1\n");
        schedulerFileContent.append("    }\n");
        schedulerFileContent.append("    Start-Sleep -Seconds 1\n");
        schedulerFileContent.append("}\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("Remove-Item $tempFile -Force\n");
        }
        Path schedulerPsFile = configDir.resolve("scheduler.ps1");
        Files.writeString(schedulerPsFile, (CharSequence)schedulerFileContent, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return schedulerPsFile;
    }

    private static Path createStartPsScript(CommandLine command, Path configDir, boolean stdinPreloaded) throws IOException {
        List<String> commandArgs = command.toList();
        StringBuilder scriptBlock = new StringBuilder();
        scriptBlock.append("$javaExe = ").append(commandArgs.get(0)).append('\n');
        if (stdinPreloaded) {
            scriptBlock.append("$tempFile = $args[0]\n");
        }
        scriptBlock.append("$javaArgs = @(").append((CharSequence)GFLauncher.toPowerShellArgumentList(commandArgs)).append(")\n");
        scriptBlock.append("Start-Process -NoNewWindow -PassThru -FilePath ");
        scriptBlock.append(commandArgs.get(0));
        if (stdinPreloaded) {
            scriptBlock.append(" -RedirectStandardInput");
            scriptBlock.append(" \"$tempFile\"");
        }
        scriptBlock.append(" -ArgumentList $javaArgs\n");
        Path startPsFile = configDir.resolve("start.ps1");
        Files.writeString(startPsFile, (CharSequence)scriptBlock, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return startPsFile;
    }

    private static StringBuilder toPowerShellArgumentList(List<String> command) {
        StringBuilder psContent = new StringBuilder();
        for (int i = 1; i < command.size(); ++i) {
            psContent.append('\n');
            psContent.append('\"');
            psContent.append(command.get(i).replace("\"", "`\""));
            psContent.append('\"');
        }
        return psContent;
    }

    private static void writeSecurityTokens(Process glassfishProcess, ProcessStreamDrainer drainer, List<String> securityTokens) throws GFLauncherException, IOException {
        OutputStream os = glassfishProcess.getOutputStream();
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os, Charset.defaultCharset());
            bw = new BufferedWriter(osw);
            for (String token : securityTokens) {
                bw.write(token);
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            GFLauncher.handleDeadProcess(glassfishProcess, drainer);
            throw e;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                GFLauncher.handleDeadProcess(glassfishProcess, drainer);
            }
        }
    }

    private static void handleDeadProcess(Process glassfishProcess, ProcessStreamDrainer drainer) throws GFLauncherException {
        String trace = GFLauncher.getDeadProcessTrace(glassfishProcess, drainer);
        if (trace != null) {
            throw new GFLauncherException(trace);
        }
    }

    private static String getDeadProcessTrace(Process process, ProcessStreamDrainer drainer) {
        if (process.isAlive()) {
            return null;
        }
        int exitValue = process.exitValue();
        if (exitValue == 0) {
            return null;
        }
        return "The server exited prematurely with exit code " + exitValue + ".\nBefore it died, it produced the following output:\n\n" + drainer.getOutErrString();
    }

    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }
}

