/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;

public class ResourceELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && property == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base and property");
            throw new PropertyNotFoundException(message);
        }
        String ret = null;
        if (base instanceof ResourceHandler) {
            Resource res;
            ResourceHandler handler = (ResourceHandler)base;
            String prop = property.toString();
            if (!prop.contains(":")) {
                res = handler.createResource(prop);
            } else {
                FacesContext facesContext;
                UIComponent currentComponent;
                Resource componentResource;
                if (!this.isPropertyValid(prop)) {
                    throw new ELException("Invalid resource format.  Property " + prop + " contains more than one colon (:)");
                }
                Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
                String[] parts = Util.split(appMap, prop, ":");
                if (null != parts[0] && parts[0].equals("this") && null != (componentResource = (Resource)(currentComponent = UIComponent.getCurrentCompositeComponent(facesContext = FacesContext.getCurrentInstance())).getAttributes().get("jakarta.faces.application.Resource.ComponentResource"))) {
                    String libName = null;
                    libName = componentResource.getLibraryName();
                    if (null != libName) {
                        parts[0] = libName;
                    }
                }
                res = handler.createResource(parts[1], parts[0]);
            }
            if (res != null) {
                FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
                ExternalContext extContext = facesContext.getExternalContext();
                ret = extContext.encodeResourceURL(res.getRequestPath());
            }
            context.setPropertyResolved(true);
        }
        return ret;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null && property == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base and property");
            throw new PropertyNotFoundException(message);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && property == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base and property");
            throw new PropertyNotFoundException(message);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && property == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base and property");
            throw new PropertyNotFoundException(message);
        }
        return false;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    private boolean isPropertyValid(String property) {
        int idx = property.indexOf(58);
        return property.indexOf(58, idx + 1) == -1;
    }
}

