/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.invoke.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jboss.weld.bean.ClassBean;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.invokable.InvokerBuilderImpl;
import org.jboss.weld.invokable.TargetMethod;
import org.jboss.weld.invoke.WeldInvokerBuilder;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractProcessClassBean<X, B extends ClassBean<X>>
extends AbstractDefinitionContainerEvent
implements ProcessBean<X> {
    private final B bean;

    public AbstractProcessClassBean(BeanManagerImpl beanManager, Type rawType, Type[] actualTypeArguments, B bean) {
        super(beanManager, rawType, actualTypeArguments);
        this.bean = bean;
    }

    public Annotated getAnnotated() {
        this.checkWithinObserverNotification();
        return this.bean.getAnnotated();
    }

    public B getBean() {
        this.checkWithinObserverNotification();
        return this.bean;
    }

    public WeldInvokerBuilder<Invoker<X, ?>> createInvoker(AnnotatedMethod<? super X> annotatedMethod) {
        this.checkWithinObserverNotification();
        Bean bean = this.getBean();
        if (bean instanceof Interceptor) {
            throw new DeploymentException("Cannot build invoker for an interceptor: " + String.valueOf(bean));
        }
        if (bean instanceof Decorator) {
            throw new DeploymentException("Cannot build invoker for a decorator: " + String.valueOf(bean));
        }
        Method method = annotatedMethod.getJavaMember();
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new DeploymentException("Cannot build invoker for a private method: " + String.valueOf(annotatedMethod));
        }
        if ("java.lang.Object".equals(method.getDeclaringClass().getName()) && !"toString".equals(method.getName())) {
            throw new DeploymentException("Cannot build invoker for a method declared on java.lang.Object: " + String.valueOf(annotatedMethod));
        }
        if (!bean.getAnnotated().getMethods().contains(annotatedMethod)) {
            throw new DeploymentException("Method does not belong to bean " + String.valueOf(bean) + ": " + String.valueOf(annotatedMethod));
        }
        return new InvokerBuilderImpl(bean.getAnnotated(), new TargetMethod(annotatedMethod), this.getBeanManager());
    }
}

