/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.RemoveExpiredResultCommand;
import org.shoal.ha.cache.impl.command.Command;

public class RemoveExpiredCommand<K, V>
extends Command {
    private static final long serialVersionUID = 5377972855354679059L;
    protected static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.remove");
    private long maxIdleInMillis;
    private long tokenId;
    private String target;

    public RemoveExpiredCommand(long maxIdleInMillis, long tokenId) {
        super((byte)39);
        this.maxIdleInMillis = maxIdleInMillis;
        this.tokenId = tokenId;
        super.setKey("RemExpired" + System.identityHashCode(this));
    }

    public void setTarget(String t) {
        this.target = t;
    }

    @Override
    public boolean beforeTransmit() {
        this.setTargetName(this.target);
        return this.target != null;
    }

    public Object getCommandKey() {
        return "RemExpired" + System.identityHashCode(this);
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeLong(this.maxIdleInMillis);
        ros.writeLong(this.tokenId);
        ros.writeUTF(this.dsc.getInstanceName());
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.maxIdleInMillis = ris.readLong();
        this.tokenId = ris.readLong();
        this.target = ris.readUTF();
    }

    @Override
    public void execute(String initiator) {
        int localResult = this.dsc.getReplicaStore().removeExpired();
        RemoveExpiredResultCommand resultCmd = new RemoveExpiredResultCommand(this.target, this.tokenId, localResult);
        try {
            this.dsc.getCommandManager().execute(resultCmd);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception while trying to send result for remove_expired", ex);
        }
    }

    @Override
    protected boolean isArtificialKey() {
        return true;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.maxIdleInMillis + ")";
    }
}

