/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.facelets;

import com.sun.jsft.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;

public class CommandParser {
    public static final String SIMPLE_WHITE_SPACE = " \t\r\n";
    private InputStream _inputStream = null;
    private transient BufferedReader _reader = null;
    private transient Stack<Character> _stack = null;

    public CommandParser(InputStream stream) {
        this._inputStream = stream;
    }

    public InputStream getInputStream() throws IOException {
        return this._inputStream;
    }

    public void open() throws IOException {
        if (this._reader != null) {
            this.close();
        }
        this._reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.getInputStream())));
        this._stack = new Stack();
    }

    public void close() {
        block3: {
            try {
                if (this._reader != null) {
                    this._reader.close();
                }
            }
            catch (Exception ex) {
                if (!LogUtil.configEnabled(this)) break block3;
                LogUtil.config("Exception while closing stream.", ex);
            }
        }
    }

    public int nextChar() throws IOException {
        if (!this._stack.empty()) {
            return this._stack.pop().charValue();
        }
        return this._reader.read();
    }

    public void unread(int ch) {
        this._stack.push(new Character((char)ch));
    }

    public String readUntil(int endingChar, boolean skipComments) throws IOException {
        return this.readUntil(new int[]{endingChar}, skipComments);
    }

    public String readUntil(int[] endingChars, boolean skipComments) throws IOException {
        if (skipComments) {
            this.skipCommentsAndWhiteSpace("");
        }
        int next = this.nextChar();
        StringBuffer buf = new StringBuffer();
        while (!this.isInArray(endingChars, next) && next != -1) {
            switch (next) {
                case 34: 
                case 39: {
                    if (skipComments) {
                        buf.append((char)next);
                        buf.append(this.readUntil(next, false));
                        buf.append((char)next);
                        this.nextChar();
                        break;
                    }
                    buf.append((char)next);
                    break;
                }
                case 35: 
                case 47: 
                case 60: {
                    if (skipComments) {
                        this.unread(next);
                        this.skipCommentsAndWhiteSpace("");
                        int tmpch = this.nextChar();
                        if (next == tmpch) {
                            buf.append((char)next);
                            break;
                        }
                        this.unread(tmpch);
                        break;
                    }
                    buf.append((char)next);
                    break;
                }
                case 92: {
                    next = this.nextChar();
                    if (next == 110) {
                        buf.append('\n');
                        break;
                    }
                    if (next == 116) {
                        buf.append('\t');
                        break;
                    }
                    if (next == 10) break;
                    buf.append((char)next);
                    break;
                }
                default: {
                    buf.append((char)next);
                }
            }
            next = this.nextChar();
        }
        if (next != -1) {
            this.unread(next);
        }
        return buf.toString();
    }

    public String readUntil(String endingStr, boolean skipComments) throws IOException {
        int cnt;
        if (endingStr == null || endingStr.length() == 0) {
            return "";
        }
        char[] arr = endingStr.toCharArray();
        int arrlen = arr.length;
        StringBuffer buf = new StringBuffer("");
        int ch = this.nextChar();
        int idx = 1;
        do {
            this.unread(ch);
            for (cnt = idx - 1; cnt > 0; --cnt) {
                this.unread(arr[cnt]);
            }
            buf.append(this.readUntil(arr[0], skipComments));
            for (idx = 1; idx < arrlen && (ch = this.nextChar()) == arr[idx]; ++idx) {
            }
        } while (ch != -1 && idx < arrlen);
        for (cnt = 1; cnt < idx; ++cnt) {
            buf.append(arr[cnt]);
        }
        if (arrlen != idx) {
            throw new IllegalStateException("Unable to find: '" + endingStr + "'.  Read to EOF and gave up.  Read: \n" + buf.toString());
        }
        return buf.toString();
    }

    public void skipWhiteSpace(String skipChars) throws IOException {
        int next = this.nextChar();
        while (next != -1 && skipChars.indexOf(next) != -1) {
            next = this.nextChar();
        }
        this.unread(next);
    }

    public void skipCommentsAndWhiteSpace(String skipChars) throws IOException {
        int ch = 0;
        block6: while (ch != -1) {
            ch = this.nextChar();
            switch (ch) {
                case 35: {
                    this.readLine();
                    continue block6;
                }
                case 47: {
                    ch = this.nextChar();
                    if (ch == 47) {
                        this.readLine();
                        continue block6;
                    }
                    if (ch == 42) {
                        this.readUntil("*/", false);
                        this.nextChar();
                        continue block6;
                    }
                    this.unread(ch);
                    this.unread(47);
                    ch = -1;
                    continue block6;
                }
                case 60: {
                    ch = this.nextChar();
                    if (ch == 33) {
                        ch = this.nextChar();
                        if (ch == 45) {
                            ch = this.nextChar();
                            if (ch == 45) {
                                this.readUntil("-->", false);
                                this.nextChar();
                                continue block6;
                            }
                            this.unread(ch);
                            this.unread(45);
                            this.unread(33);
                            this.unread(60);
                            throw new IllegalArgumentException("Invalid comment!  Expected comment to begin with \"<!--\", but found: " + this.readLine());
                        }
                        this.unread(ch);
                        this.unread(33);
                        this.unread(60);
                        ch = -1;
                        continue block6;
                    }
                    this.unread(ch);
                    this.unread(60);
                    ch = -1;
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
            }
            if (skipChars.indexOf(ch) != -1) continue;
            this.unread(ch);
            ch = -1;
        }
    }

    public String readLine() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = -1;
        while (!this._stack.empty()) {
            ch = this._stack.pop().charValue();
            if (ch == 13 || ch == 10) {
                if (!(this._stack.empty() || (ch = (int)this._stack.peek().charValue()) != 13 && ch != 10)) {
                    this._stack.pop().charValue();
                }
                return buf.toString();
            }
            buf.append((char)ch);
        }
        buf.append(this._reader.readLine());
        int idx = buf.indexOf("\\n");
        while (idx != -1) {
            buf.replace(idx, idx + 2, "\n");
            idx = buf.indexOf("\\n", idx + 1);
        }
        int lastChar = buf.length() - 1;
        if (lastChar >= 0 && buf.charAt(lastChar) == '\\') {
            buf.deleteCharAt(lastChar);
            buf.append(this.readLine());
        }
        return buf.toString();
    }

    private boolean isInArray(int[] arr, int val) {
        int len = arr.length;
        for (int idx = 0; idx < len; ++idx) {
            if (arr[idx] != val) continue;
            return true;
        }
        return false;
    }
}

