/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.jsp;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.wasp.JspC;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.runtime.JspConfig;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.runtime.WebProperty;

public final class JSPCompiler {
    private static final Logger LOG = LogFacade.getLogger();

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, ServerContext serverContext) throws DeploymentException {
        JSPCompiler.compile(inWebDir, outWebDir, wbd, (String)null, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, List<String> classpathList, ServerContext serverContext) throws DeploymentException {
        String classpath = classpathList == null ? null : JSPCompiler.getClasspath(classpathList);
        JSPCompiler.compile(inWebDir, outWebDir, wbd, classpath, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, String classpath, ServerContext serverContext) throws DeploymentException {
        LOG.log(Level.FINEST, "Compiling JSP: in={0}, out={1}, classpath={2}", new Object[]{inWebDir, outWebDir, classpath});
        JspC jspc = new JspC();
        if (classpath != null && !classpath.isEmpty()) {
            jspc.setClassPath(classpath);
        }
        String appName = wbd.getApplication().getName();
        String sysClassPath = ASClassLoaderUtil.getModuleClassPath((ServiceLocator)serverContext.getDefaultServices(), (String)appName, null);
        jspc.setSystemClassPath(sysClassPath);
        JSPCompiler.verify(inWebDir, outWebDir);
        JSPCompiler.configureJspc(jspc, wbd);
        jspc.setOutputDir(outWebDir.getAbsolutePath());
        jspc.setUriroot(inWebDir.getAbsolutePath());
        jspc.setCompile(true);
        LOG.log(Level.INFO, "AS-WEB-GLUE-00281");
        try {
            jspc.execute();
        }
        catch (Exception je) {
            throw new DeploymentException("JSP Compilation Error: " + String.valueOf(je), (Throwable)je);
        }
        finally {
            String[] files = outWebDir.list();
            if (!(files != null && files.length > 0 || outWebDir.delete())) {
                LOG.log(Level.FINE, "AS-WEB-GLUE-00283", outWebDir);
            }
            LOG.log(Level.INFO, "AS-WEB-GLUE-00282");
        }
    }

    private static void verify(File inWebDir, File outWebDir) throws DeploymentException {
        if (!FileUtils.safeIsDirectory((File)inWebDir)) {
            throw new DeploymentException("inWebDir is not a directory: " + String.valueOf(inWebDir));
        }
        if (!FileUtils.safeIsDirectory((File)outWebDir)) {
            if (!outWebDir.mkdirs()) {
                LOG.log(Level.FINE, "AS-WEB-GLUE-00283", outWebDir);
            }
            if (!FileUtils.safeIsDirectory((File)outWebDir)) {
                throw new DeploymentException("outWebDir is not a directory, and it can't be created: " + String.valueOf(outWebDir));
            }
        }
    }

    private static String getClasspath(List<String> paths) {
        if (paths == null) {
            return null;
        }
        String classpath = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            classpath = sb.toString();
        }
        return classpath;
    }

    private static void configureJspc(JspC jspc, WebBundleDescriptor wbd) {
        JspConfig jspConfig;
        Set set;
        SunWebAppImpl sunWebApp = (SunWebAppImpl)wbd.getSunDescriptor();
        if (sunWebApp == null) {
            return;
        }
        if (sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] props = sunWebApp.getWebProperty();
            for (WebProperty prop : props) {
                String pName = (String)prop.getValue("name");
                String pValue = (String)prop.getValue("value");
                if (pName == null || pValue == null) {
                    throw new IllegalArgumentException("Missing sun-web-app property name or value");
                }
                if (!"enableTldValidation".equals(pName)) continue;
                jspc.setIsValidationEnabled(Boolean.parseBoolean(pValue));
            }
        }
        if (!(set = wbd.getWebComponentDescriptors()).isEmpty()) {
            for (WebComponentDescriptor webComponentDesc : set) {
                if (!"jsp".equals(webComponentDesc.getCanonicalName())) continue;
                Enumeration en = webComponentDesc.getInitializationParameters();
                if (en == null) break;
                while (en.hasMoreElements()) {
                    InitializationParameter initP = (InitializationParameter)en.nextElement();
                    JSPCompiler.configureJspc(jspc, initP.getName(), initP.getValue());
                }
                break block1;
            }
        }
        if ((jspConfig = sunWebApp.getJspConfig()) == null) {
            return;
        }
        WebProperty[] props = jspConfig.getWebProperty();
        for (int i = 0; props != null && i < props.length; ++i) {
            JSPCompiler.configureJspc(jspc, (String)props[i].getValue("name"), (String)props[i].getValue("value"));
        }
    }

    private static void configureJspc(JspC jspc, String pName, String pValue) {
        if (pName == null || pValue == null) {
            throw new IllegalArgumentException("Null property name or value");
        }
        if ("xpoweredBy".equals(pName)) {
            jspc.setXpoweredBy(Boolean.parseBoolean(pValue));
        } else if ("classdebuginfo".equals(pName)) {
            jspc.setClassDebugInfo(Boolean.parseBoolean(pValue));
        } else if ("enablePooling".equals(pName)) {
            jspc.setPoolingEnabled(Boolean.parseBoolean(pValue));
        } else if ("trimSpaces".equals(pName)) {
            jspc.setTrimSpaces(Boolean.parseBoolean(pValue));
        } else if ("genStrAsCharArray".equals(pName)) {
            jspc.setGenStringAsCharArray(Boolean.parseBoolean(pValue));
        } else if ("errorOnUseBeanInvalidClassAttribute".equals(pName)) {
            jspc.setErrorOnUseBeanInvalidClassAttribute(Boolean.parseBoolean(pValue));
        } else if ("ignoreJspFragmentErrors".equals(pName)) {
            jspc.setIgnoreJspFragmentErrors(Boolean.parseBoolean(pValue));
        } else if ("compilerSourceVM".equals(pName)) {
            jspc.setCompilerSourceVM(pValue);
        } else if ("compilerTargetVM".equals(pName)) {
            jspc.setCompilerTargetVM(pValue);
        }
    }
}

