/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import java.io.BufferedReader;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;

public interface LogParser {
    public static final DateTimeFormatter ISO_LOCAL_TIME_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter(Locale.ROOT);
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(ISO_LOCAL_TIME_PARSER).toFormatter(Locale.ROOT);
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_TIME_PARSER).optionalStart().appendOffsetId().optionalEnd().optionalStart().appendOffset("+HHMMss", "Z").optionalEnd().toFormatter(Locale.ROOT);

    public static Long toLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer toInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void parseLog(BufferedReader var1, LogParserListener var2) throws LogParserException;
}

