/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.persistence.PersistenceUnit;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=PersistenceUnit.class)
public class EntityManagerFactoryReferenceHandler
extends AbstractResourceHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        PersistenceUnit emfRefAn = (PersistenceUnit)ainfo.getAnnotation();
        return this.processEmfRef(ainfo, rcContexts, emfRefAn);
    }

    protected HandlerProcessingResult processEmfRef(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, PersistenceUnit emfRefAn) throws AnnotationProcessorException {
        block7: {
            EntityManagerFactoryReferenceDescriptor[] emfRefs;
            block8: {
                block6: {
                    if (!ElementType.FIELD.equals((Object)ainfo.getElementType())) break block6;
                    Field f = (Field)ainfo.getAnnotatedElement();
                    String targetClassName = f.getDeclaringClass().getName();
                    Object logicalName = emfRefAn.name();
                    if (((String)logicalName).isEmpty()) {
                        logicalName = targetClassName + "/" + f.getName();
                    }
                    EntityManagerFactoryReferenceDescriptor[] emfRefs2 = this.getEmfReferenceDescriptors((String)logicalName, rcContexts);
                    InjectionTarget target = new InjectionTarget();
                    target.setFieldName(f.getName());
                    target.setClassName(targetClassName);
                    target.setMetadataSource(MetadataSource.ANNOTATION);
                    for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs2) {
                        emfRef.addInjectionTarget(target);
                        if (!emfRef.getName().isEmpty()) continue;
                        this.processNewEmfRefAnnotation(emfRef, (String)logicalName, emfRefAn);
                    }
                    break block7;
                }
                if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) break block8;
                Method m = (Method)ainfo.getAnnotatedElement();
                String targetClassName = m.getDeclaringClass().getName();
                Object logicalName = emfRefAn.name();
                if (((String)logicalName).isEmpty()) {
                    String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
                    logicalName = targetClassName + "/" + propertyName;
                }
                this.validateInjectionMethod(m, ainfo);
                EntityManagerFactoryReferenceDescriptor[] emfRefs3 = this.getEmfReferenceDescriptors((String)logicalName, rcContexts);
                InjectionTarget target = new InjectionTarget();
                target.setMethodName(m.getName());
                target.setClassName(targetClassName);
                target.setMetadataSource(MetadataSource.ANNOTATION);
                for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs3) {
                    emfRef.addInjectionTarget(target);
                    if (!emfRef.getName().isEmpty()) continue;
                    this.processNewEmfRefAnnotation(emfRef, (String)logicalName, emfRefAn);
                }
                break block7;
            }
            if (!ElementType.TYPE.equals((Object)ainfo.getElementType())) break block7;
            String logicalName = emfRefAn.name();
            if (logicalName.isEmpty()) {
                this.log(Level.SEVERE, ainfo, I18N.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation symbol on class must specify name."));
                return this.getDefaultFailedResult();
            }
            for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs = this.getEmfReferenceDescriptors(logicalName, rcContexts)) {
                if (!emfRef.getName().isEmpty()) continue;
                this.processNewEmfRefAnnotation(emfRef, logicalName, emfRefAn);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private EntityManagerFactoryReferenceDescriptor[] getEmfReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EntityManagerFactoryReferenceDescriptor[] emfRefs = new EntityManagerFactoryReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EntityManagerFactoryReferenceDescriptor emfRef = rcContexts[i].getEntityManagerFactoryReference(logicalName);
            if (emfRef == null) {
                emfRef = new EntityManagerFactoryReferenceDescriptor();
                rcContexts[i].addEntityManagerFactoryReferenceDescriptor(emfRef);
            }
            emfRefs[i] = emfRef;
        }
        return emfRefs;
    }

    private void processNewEmfRefAnnotation(EntityManagerFactoryReferenceDescriptor emfRef, String logicalName, PersistenceUnit annotation) {
        emfRef.setName(logicalName);
        if (!annotation.unitName().isEmpty()) {
            emfRef.setUnitName(annotation.unitName());
        }
    }
}

