/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.SessionCookieConfig;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.DefaultSessionManager;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.ServletHandler;

public class ServletSessionManager
implements SessionManager {
    private final SessionManager defaultManager = DefaultSessionManager.instance();
    private String sessionCookieName = "JSESSIONID";

    public static SessionManager instance() {
        return LazyHolder.INSTANCE;
    }

    private ServletSessionManager() {
    }

    public Session getSession(Request request, String requestedSessionId) {
        return this.defaultManager.getSession(request, requestedSessionId);
    }

    public Session createSession(Request request) {
        return this.defaultManager.createSession(request);
    }

    public String changeSessionId(Request request, Session session) {
        return this.defaultManager.changeSessionId(request, session);
    }

    public void configureSessionCookie(Request request, Cookie cookie) {
        this.defaultManager.configureSessionCookie(request, cookie);
        HttpServletRequestImpl servletRequest = ServletHandler.getServletRequest(request);
        assert (servletRequest != null);
        SessionCookieConfig cookieConfig = servletRequest.getContextImpl().getSessionCookieConfig();
        if (cookieConfig.getDomain() != null) {
            cookie.setDomain(cookieConfig.getDomain());
        }
        if (cookieConfig.getPath() != null) {
            cookie.setPath(cookieConfig.getPath());
        }
        if (cookieConfig.getComment() != null) {
            cookie.setVersion(1);
            cookie.setComment(cookieConfig.getComment());
        }
        cookie.setSecure(cookieConfig.isSecure());
        cookie.setHttpOnly(cookieConfig.isHttpOnly());
        cookie.setMaxAge(cookieConfig.getMaxAge());
    }

    public void setSessionCookieName(String name) {
        if (name != null && !name.isEmpty()) {
            this.sessionCookieName = name;
        }
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    private static class LazyHolder {
        private static final ServletSessionManager INSTANCE = new ServletSessionManager();

        private LazyHolder() {
        }
    }
}

