/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ProgressBar;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;

public final class ProgressBarRenderer
extends RendererBase {
    private static final String[] ATTRIBUTES = new String[]{"style"};

    @Override
    protected String[] getModuleNames(UIComponent component) {
        ProgressBar progressBar = (ProgressBar)component;
        if (progressBar.isAjaxify()) {
            return new String[]{"progressBar", "jsfx/progressBar"};
        }
        return new String[]{"progressBar"};
    }

    @Override
    protected JsonObjectBuilder getProperties(FacesContext context, UIComponent component) throws IOException {
        ProgressBar progressBar = (ProgressBar)component;
        Theme theme = ThemeUtilities.getTheme(context);
        JsonObjectBuilder jsonBuilder = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("barHeight", progressBar.getHeight()).add("barWidth", progressBar.getWidth()).add("failedStateText", JsonUtilities.jsonValueOf(progressBar.getFailedStateText())).add("logMessage", JsonUtilities.jsonValueOf(progressBar.getLogMessage())).add("overlayAnimation", progressBar.isOverlayAnimation()).add("percentChar", JsonUtilities.jsonValueOf(theme.getMessage("ProgressBar.percentChar"))).add("progress", progressBar.getProgress()).add("progressImageUrl", JsonUtilities.jsonValueOf(progressBar.getProgressImageUrl())).add("refreshRate", progressBar.getRefreshRate()).add("taskState", JsonUtilities.jsonValueOf(progressBar.getTaskState()));
        if (progressBar.getToolTip() != null) {
            jsonBuilder.add("toolTip", progressBar.getToolTip());
        } else {
            jsonBuilder.add("toolTip", theme.getMessage("ProgressBar.toolTip"));
        }
        jsonBuilder.add("type", progressBar.getType());
        jsonBuilder.add("visible", progressBar.isVisible());
        ProgressBarRenderer.addAttributeProperties(ATTRIBUTES, component, jsonBuilder);
        return jsonBuilder;
    }

    @Override
    protected void renderNestedContent(FacesContext context, UIComponent component) throws IOException {
        UIComponent bottomTextFacet;
        ResponseWriter writer = context.getResponseWriter();
        ProgressBar pb = (ProgressBar)component;
        writer.append((CharSequence)WidgetUtilities.renderComponent(context, pb.getBusyIcon()));
        UIComponent rightButtonCon = component.getFacet("progressControlRight");
        UIComponent bottomButtonCon = component.getFacet("progressControlBottom");
        if (rightButtonCon != null) {
            writer.append((CharSequence)WidgetUtilities.renderComponent(context, rightButtonCon));
        }
        if (bottomButtonCon != null) {
            writer.append((CharSequence)WidgetUtilities.renderComponent(context, bottomButtonCon));
        }
        if (pb.getLogMessage() != null) {
            TextArea textArea = (TextArea)pb.getLogMsgComponent(pb);
            writer.append((CharSequence)WidgetUtilities.renderComponent(context, (UIComponent)textArea));
        }
        if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
            writer.append((CharSequence)WidgetUtilities.renderComponent(context, bottomTextFacet));
        } else {
            writer.append((CharSequence)"<span>bottomText:").append(pb.getStatus()).append("</span>");
        }
        UIComponent topTextFacet = component.getFacet("progressTextTop");
        if (topTextFacet != null) {
            writer.append((CharSequence)WidgetUtilities.renderComponent(context, topTextFacet));
        } else {
            writer.append((CharSequence)"<span>topText:").append(pb.getDescription()).append("</span>");
        }
    }
}

