/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.LogFacade;
import org.glassfish.concurrent.runtime.deployer.cfg.ContextServiceCfg;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=org.glassfish.concurrent.config.ContextService.class)
public class ContextServiceDeployer
implements ResourceDeployer<org.glassfish.concurrent.config.ContextService> {
    private static final Logger LOG = LogFacade.getLogger();
    @Inject
    private ResourceNamingService namingService;
    @Inject
    private ConcurrentRuntime concurrentRuntime;

    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.concurrent.config.ContextService;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    public void deployResource(org.glassfish.concurrent.config.ContextService resource) throws Exception {
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)resource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void deployResource(org.glassfish.concurrent.config.ContextService resource, String applicationName, String moduleName) throws Exception {
        if (resource == null) {
            LOG.log(Level.WARNING, "AS-CONCURRENT-00004", "ContextService");
            return;
        }
        SimpleJndiName jndiName = new SimpleJndiName(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        ContextServiceCfg config = new ContextServiceCfg(resource);
        Reference ref = new Reference(ContextService.class.getName(), "org.glassfish.concurrent.runtime.deployer.ConcurrentObjectFactory", null);
        SerializableObjectRefAddr addr = new SerializableObjectRefAddr(ContextServiceCfg.class.getName(), (Object)config);
        ref.add((RefAddr)addr);
        SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), (Object)resourceInfo);
        ref.add((RefAddr)resAddr);
        try {
            this.namingService.publishObject((GenericResourceInfo)resourceInfo, (Object)ref, true);
        }
        catch (NamingException ex) {
            LogHelper.log((Logger)LOG, (Level)Level.SEVERE, (String)"AS-CONCURRENT-00003", (Throwable)ex, (Object[])new Object[]{"ContextService", jndiName});
        }
    }

    public void undeployResource(org.glassfish.concurrent.config.ContextService resource) throws Exception {
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)resource);
        this.undeployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(org.glassfish.concurrent.config.ContextService resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName simpleJndiName = new SimpleJndiName(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(simpleJndiName, applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, simpleJndiName);
        this.concurrentRuntime.shutdownContextService(simpleJndiName);
    }
}

