/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.weld.contexts.cache.RequestScopedCache;
import org.jboss.weld.contexts.cache.RequestScopedItem;

public class ThreadLocalStack<T> {
    private final ThreadLocal<Stack<T>> threadLocalStack = new ThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack(this);
        }
    };
    private static final ThreadLocalStackReference<Object> NULL_REFERENCE = new ThreadLocalStackReference<Object>(){

        @Override
        public Object pop() {
            return null;
        }
    };

    public ThreadLocalStackReference<T> push(T item) {
        Stack<T> stack = this.threadLocalStack.get();
        stack.push(item);
        return stack;
    }

    public T peek() {
        Stack<T> stack = this.threadLocalStack.get();
        T top = stack.peek();
        ((Stack)stack).removeIfEmpty();
        return top;
    }

    public ThreadLocalStackReference<T> pushConditionally(T item, boolean condition) {
        if (condition) {
            return this.push(item);
        }
        return NULL_REFERENCE;
    }

    public ThreadLocalStackReference<T> pushIfNotNull(T item) {
        return this.pushConditionally(item, item != null);
    }

    private static class Stack<T>
    implements RequestScopedItem,
    ThreadLocalStackReference<T> {
        private final Deque<T> elements;
        private final ThreadLocal<Stack<T>> interceptionContexts;
        private boolean removeWhenEmpty;
        private boolean valid;

        private Stack(ThreadLocal<Stack<T>> interceptionContexts) {
            this.interceptionContexts = interceptionContexts;
            this.elements = new ArrayDeque<T>();
            this.removeWhenEmpty = !RequestScopedCache.addItemIfActive(this);
            this.valid = true;
        }

        private void checkState() {
            if (!this.valid) {
                throw new IllegalStateException("This ThreadLocalStack is no longer valid.");
            }
        }

        public void push(T item) {
            this.checkState();
            this.elements.addFirst(item);
        }

        public T peek() {
            this.checkState();
            return this.elements.peekFirst();
        }

        @Override
        public T pop() {
            this.checkState();
            T top = this.elements.removeFirst();
            this.removeIfEmpty();
            return top;
        }

        private void removeIfEmpty() {
            if (this.removeWhenEmpty && this.elements.isEmpty()) {
                this.interceptionContexts.remove();
                this.valid = false;
            }
        }

        @Override
        public void invalidate() {
            this.removeWhenEmpty = true;
            this.removeIfEmpty();
        }
    }

    public static interface ThreadLocalStackReference<T> {
        public T pop();
    }
}

