/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.HttpCommand;
import com.sun.enterprise.admin.remote.ParamsWithPayload;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiver;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiverProprietaryReader;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriter;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;

public class ExecHttpCommand
implements HttpCommand<ActionReport> {
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String MEDIATYPE_MULTIPART = "multipart/*";
    private static final String MEDIATYPE_SSE = "text/event-stream";
    private static final System.Logger LOG = System.getLogger(ExecHttpCommand.class.getName());
    private final ParameterMap params;
    private final boolean detached;
    private final boolean useSSE;
    private final AtomicBoolean closeSSE;
    private final boolean doUpload;
    private final RestPayloadImpl.Outbound payload;
    private final File fileOutputDir;
    private final Consumer<GfSseInboundEvent> eventConsumer;
    private final Consumer<String> jobPayloadDownloader;

    public ExecHttpCommand(ParameterMap params, boolean detached, boolean useSSE, AtomicBoolean closeSSE, boolean doUpload, RestPayloadImpl.Outbound payload, File fileOutputDir, Consumer<GfSseInboundEvent> eventConsumer, Consumer<String> jobPayloadDownloader) {
        this.params = params;
        this.detached = detached;
        this.useSSE = useSSE;
        this.closeSSE = closeSSE;
        this.doUpload = doUpload;
        this.payload = payload;
        this.fileOutputDir = fileOutputDir;
        this.eventConsumer = eventConsumer;
        this.jobPayloadDownloader = jobPayloadDownloader;
    }

    @Override
    public void prepareConnection(HttpURLConnection urlConnection) throws IOException {
        ParamsWithPayload pwp;
        if (this.useSSE) {
            urlConnection.addRequestProperty("Accept", MEDIATYPE_SSE);
        } else {
            urlConnection.addRequestProperty("Accept", "application/json; q=0.8, multipart/*; q=0.9");
        }
        if (this.doUpload) {
            urlConnection.setChunkedStreamingMode(0);
            pwp = new ParamsWithPayload(this.payload, this.params);
        } else {
            pwp = new ParamsWithPayload(null, this.params);
        }
        ProprietaryWriter writer = ProprietaryWriterFactory.getWriter(pwp);
        LOG.log(System.Logger.Level.DEBUG, () -> "Writer to use " + writer.getClass().getName());
        writer.writeTo(pwp, urlConnection);
    }

    @Override
    public ActionReport useConnection(HttpURLConnection urlConnection) throws CommandException, IOException {
        String resultMediaType = urlConnection.getContentType();
        LOG.log(System.Logger.Level.DEBUG, "Result type is {0}", resultMediaType);
        LOG.log(System.Logger.Level.DEBUG, "URL connection is {0}", urlConnection.getClass().getName());
        if (resultMediaType != null && resultMediaType.startsWith(MEDIATYPE_SSE)) {
            return this.processSSE(urlConnection, resultMediaType);
        }
        ProprietaryReader<ParamsWithPayload> reader = ProprietaryReaderFactory.getReader(ParamsWithPayload.class, resultMediaType);
        if (urlConnection.getResponseCode() == 500) {
            return this.reportInternalError(urlConnection, resultMediaType, reader);
        }
        ParamsWithPayload pwp = reader.readFrom(urlConnection.getInputStream(), resultMediaType);
        if (pwp.getPayloadInbound() == null) {
            return pwp.getActionReport();
        }
        if (resultMediaType != null && resultMediaType.startsWith("multipart/")) {
            RestPayloadImpl.Inbound inbound = pwp.getPayloadInbound();
            ActionReport report = pwp.getActionReport();
            if (LOG.isLoggable(System.Logger.Level.TRACE)) {
                LOG.log(System.Logger.Level.TRACE, "------ PAYLOAD ------");
                Iterator<Payload.Part> parts = inbound.parts();
                while (parts.hasNext()) {
                    Payload.Part part = parts.next();
                    LOG.log(System.Logger.Level.TRACE, " - {0} [{1}]", part.getName(), part.getContentType());
                }
                LOG.log(System.Logger.Level.TRACE, "---- END PAYLOAD ----");
            }
            PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm(this.fileOutputDir, null, null);
            try {
                downloadedFilesMgr.processParts((Payload.Inbound)inbound);
            }
            catch (CommandException cex) {
                throw cex;
            }
            catch (Exception ex) {
                throw new CommandException(ex.getMessage(), (Throwable)ex);
            }
            return report;
        }
        throw new IllegalStateException("Unknown media type: " + resultMediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActionReport processSSE(HttpURLConnection urlConnection, String resultMediaType) throws CommandException {
        String instanceId = null;
        boolean retryableCommand = false;
        try (GfSseEventReceiver eventReceiver = this.openEventReceiver(urlConnection, resultMediaType);){
            GfSseInboundEvent event;
            LOG.log(System.Logger.Level.DEBUG, "Response is SSE - about to read events");
            do {
                if ((event = eventReceiver.readEvent()) == null) continue;
                LOG.log(System.Logger.Level.DEBUG, "Event name: {0}", event.getName());
                this.eventConsumer.accept(event);
                if (!"AdminCommandState/stateChanged".equals(event.getName())) continue;
                AdminCommandState state = event.getData(AdminCommandState.class, MEDIATYPE_JSON);
                if (state.getId() == null) {
                    if (this.detached && !this.closeSSE.get()) {
                        LOG.log(System.Logger.Level.TRACE, "Command instance job ID missing, waiting for another message.");
                        continue;
                    }
                } else {
                    instanceId = state.getId();
                    LOG.log(System.Logger.Level.DEBUG, "Command instance job ID: {0}", instanceId);
                }
                if (this.closeSSE.get()) {
                    LOG.log(System.Logger.Level.TRACE, "DetachListener already did its job.");
                    ActionReport actionReport = null;
                    return actionReport;
                }
                if (state.getState() == AdminCommandState.State.COMPLETED || state.getState() == AdminCommandState.State.RECORDED || state.getState() == AdminCommandState.State.REVERTED) {
                    if (!state.isOutboundPayloadEmpty()) {
                        LOG.log(System.Logger.Level.DEBUG, "Remote command holds data. Must load it");
                        this.jobPayloadDownloader.accept(instanceId);
                    }
                    this.closeSSE.set(true);
                    ActionReport actionReport = state.getActionReport();
                    return actionReport;
                }
                if (state.getState() == AdminCommandState.State.FAILED_RETRYABLE) {
                    LOG.log(System.Logger.Level.INFO, "Command is parked. Continue in it using command \"continue " + state.getId() + "\" or revert using \"revert " + state.getId() + "\".");
                    this.closeSSE.set(true);
                    ActionReport actionReport = state.getActionReport();
                    return actionReport;
                }
                if (state.getState() != AdminCommandState.State.RUNNING_RETRYABLE) continue;
                LOG.log(System.Logger.Level.DEBUG, "Command stores checkpoint and is retryable");
                retryableCommand = true;
            } while (event != null && !eventReceiver.isClosed() && !this.closeSSE.get());
            ActionReport actionReport = null;
            return actionReport;
        }
        catch (IOException e) {
            if (instanceId == null) throw new CommandException(e.getMessage(), (Throwable)e);
            if (!"Premature EOF".equals(e.getMessage())) {
                throw new CommandException(e.getMessage(), (Throwable)e);
            }
            if (!retryableCommand) throw new CommandException("Connection to the server lost.\nIf server is still running, it is possible to reconnect using subcommand attach " + instanceId, (Throwable)e);
            throw new CommandException("Connection to the server lost. \nIf the server is not running, the command will be resumed automatically at next server startup. Result can be seen in server.log or by reconnecting using subcommand attach " + instanceId, (Throwable)e);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    private GfSseEventReceiver openEventReceiver(HttpURLConnection urlConnection, String resultMediaType) {
        GfSseEventReceiverProprietaryReader reader = new GfSseEventReceiverProprietaryReader();
        try {
            InputStream inputStream = urlConnection.getInputStream();
            return (GfSseEventReceiver)reader.readFrom(inputStream, resultMediaType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open the even receiver.", e);
        }
    }

    private ActionReport reportInternalError(HttpURLConnection urlConnection, String resultMediaType, ProprietaryReader<ParamsWithPayload> reader) throws IOException {
        if (reader != null) {
            return reader.readFrom(urlConnection.getErrorStream(), resultMediaType).getActionReport();
        }
        CliActionReport report = new CliActionReport();
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setMessage(urlConnection.getResponseMessage());
        return report;
    }
}

