/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.cdi;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.cdi.AroundController;
import org.eclipse.krazo.lifecycle.RequestLifecycle;

@Interceptor
@AroundController
@Priority(value=4000)
public class AroundControllerInterceptor
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(AroundControllerInterceptor.class.getName());
    private static final long serialVersionUID = -5804986456381504613L;
    @Inject
    private RequestLifecycle requestLifecycle;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        LOGGER.log(Level.FINE, "Invoking method: {0}#{1}", new Object[]{ctx.getMethod().getDeclaringClass().getName(), ctx.getMethod().getName()});
        return this.requestLifecycle.aroundController(ctx.getMethod(), () -> ((InvocationContext)ctx).proceed());
    }
}

