/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.util;

import com.sun.corba.ee.impl.util.JDKClassLoader;
import com.sun.corba.ee.org.omg.CORBA.GetPropertyAction;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKBridge {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static Logger logger = Logger.getLogger(JDKBridge.class.getName());
    private static final String LOCAL_CODEBASE_KEY = "java.rmi.server.codebase";
    private static final String USE_CODEBASE_ONLY_KEY = "java.rmi.server.useCodebaseOnly";
    private static String localCodebase = null;
    private static boolean useCodebaseOnly;

    public static String getLocalCodebase() {
        return localCodebase;
    }

    public static boolean useCodebaseOnly() {
        return useCodebaseOnly;
    }

    public static Class loadClass(String className, String remoteCodebase, ClassLoader loader) throws ClassNotFoundException {
        Class<?> cls = null;
        if (cls == null) {
            if (loader == null) {
                cls = JDKBridge.loadClassM(className, remoteCodebase, useCodebaseOnly);
            } else {
                try {
                    cls = JDKBridge.loadClassM(className, remoteCodebase, useCodebaseOnly);
                }
                catch (ClassNotFoundException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        wrapper.classNotFoundInCodebase(className, remoteCodebase);
                    }
                    cls = loader.loadClass(className);
                }
            }
        }
        return cls;
    }

    public static Class loadClass(String className, String remoteCodebase) throws ClassNotFoundException {
        return JDKBridge.loadClass(className, remoteCodebase, null);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return JDKBridge.loadClass(className, null, null);
    }

    public static synchronized void setCodebaseProperties() {
        String prop = (String)AccessController.doPrivileged(new GetPropertyAction(LOCAL_CODEBASE_KEY));
        if (prop != null && prop.trim().length() > 0) {
            localCodebase = prop;
        }
        if ((prop = (String)AccessController.doPrivileged(new GetPropertyAction(USE_CODEBASE_ONLY_KEY))) != null && prop.trim().length() > 0) {
            useCodebaseOnly = Boolean.valueOf(prop);
        }
    }

    public static synchronized void setLocalCodebase(String codebase) {
        localCodebase = codebase;
    }

    private static Class loadClassM(String className, String remoteCodebase, boolean useCodebaseOnly) throws ClassNotFoundException {
        try {
            return JDKClassLoader.loadClass(null, (String)className);
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(Level.FINE)) {
                wrapper.classNotFoundInJDKClassLoader((String)className, e);
            }
            try {
                if (!useCodebaseOnly && remoteCodebase != null) {
                    return RMIClassLoader.loadClass(remoteCodebase, (String)className);
                }
                return RMIClassLoader.loadClass((String)className);
            }
            catch (MalformedURLException e2) {
                className = (String)className + ": " + e2.toString();
                throw new ClassNotFoundException((String)className);
            }
        }
    }

    static {
        JDKBridge.setCodebaseProperties();
    }

    private static class LoadClassCache {
        private static Map<String, Map<String, Entry>> nullLoaderMap = new HashMap<String, Map<String, Entry>>();
        private static Map<ClassLoader, Map<String, Entry>> nonNullLoaderMap = new WeakHashMap<ClassLoader, Map<String, Entry>>();
        private static ReferenceQueue<Class> queue = new ReferenceQueue();

        private LoadClassCache() {
        }

        private static void checkQueue() {
            Reference<Class> obj;
            while ((obj = queue.poll()) != null) {
                Map<String, Entry> mse;
                Entry entry = (Entry)obj;
                String className = ((Class)entry.get()).getName();
                if (entry.loader == null) {
                    mse = nullLoaderMap.get(entry.codeBase);
                    mse.remove(className);
                    if (mse.isEmpty()) {
                        nullLoaderMap.remove(entry.codeBase);
                    }
                } else {
                    mse = nonNullLoaderMap.get(entry.loader);
                    mse.remove(className);
                    if (mse.isEmpty()) {
                        nonNullLoaderMap.remove(entry.loader);
                    }
                }
                entry.clear();
            }
            return;
        }

        public static synchronized Class get(String className, String remoteCodebase, ClassLoader loader) throws ClassNotFoundException {
            Entry entry;
            LoadClassCache.checkQueue();
            Map<String, Entry> scm = loader == null ? nullLoaderMap.get(remoteCodebase) : nonNullLoaderMap.get(loader);
            Class cls = null;
            if (scm != null && (entry = scm.get(className)) != null) {
                cls = (Class)entry.get();
            }
            return cls;
        }

        public static synchronized void put(String className, String remoteCodebase, ClassLoader loader, Class cls) {
            Map<String, Entry> scm;
            LoadClassCache.checkQueue();
            if (loader == null) {
                scm = nullLoaderMap.get(remoteCodebase);
                if (scm == null) {
                    scm = new HashMap<String, Entry>();
                    nullLoaderMap.put(remoteCodebase, scm);
                }
            } else {
                scm = nonNullLoaderMap.get(loader);
                if (scm == null) {
                    scm = new HashMap<String, Entry>();
                    nonNullLoaderMap.put(loader, scm);
                }
            }
            scm.put(className, new Entry(cls, remoteCodebase, loader));
        }

        private static class Entry
        extends SoftReference<Class> {
            String codeBase;
            ClassLoader loader;

            public Entry(Class cls, String codeBase, ClassLoader loader) {
                super(cls, queue);
                this.codeBase = codeBase;
                this.loader = loader;
            }

            @Override
            public void clear() {
                this.codeBase = null;
                this.loader = null;
            }
        }
    }
}

