/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBObjectImpl;
import jakarta.ejb.EJBObject;

public class EJBContainerStateManager {
    Container container;

    EJBContainerStateManager(Container c) {
        this.container = c;
    }

    public boolean isNullEJBObject(EJBContextImpl context) {
        return context.getEJBObjectImpl() == null;
    }

    public boolean isNullEJBLocalObject(EJBContextImpl context) {
        return context.getEJBLocalObjectImpl() == null;
    }

    public boolean isRemovedEJBObject(EjbInvocation inv) {
        return inv.ejbObject.isRemoved();
    }

    public boolean isRemovedEJBObject(EJBContextImpl context) {
        return !this.isNullEJBObject(context) && context.getEJBObjectImpl().isRemoved();
    }

    public boolean isRemovedEJBLocalObject(EJBContextImpl context) {
        return !this.isNullEJBLocalObject(context) && context.getEJBLocalObjectImpl().isRemoved();
    }

    public void attachObject(EjbInvocation inv, EJBContextImpl context, EJBObjectImpl ejbObjImpl, EJBLocalObjectImpl localObjImpl) {
        if (ejbObjImpl != null && this.container.isRemoteObject() && !inv.isLocal) {
            context.setEJBObjectImpl(ejbObjImpl);
            context.setEJBStub((EJBObject)ejbObjImpl.getStub());
        }
        if (localObjImpl != null && this.container.isLocalObject()) {
            context.setEJBLocalObjectImpl(localObjImpl);
        }
        if (inv.isLocal && localObjImpl != null) {
            inv.ejbObject = localObjImpl;
        } else if (ejbObjImpl != null) {
            inv.ejbObject = ejbObjImpl;
        }
    }

    public void markObjectRemoved(EJBContextImpl context, boolean removed) {
        if (!this.isNullEJBObject(context)) {
            context.getEJBObjectImpl().setRemoved(removed);
        }
        if (!this.isNullEJBLocalObject(context)) {
            context.getEJBLocalObjectImpl().setRemoved(removed);
        }
    }

    public void disconnectContext(EJBContextImpl context) {
        if (!this.isNullEJBObject(context)) {
            context.getEJBObjectImpl().setRemoved(false);
            context.setEJBObjectImpl(null);
            context.setEJBStub(null);
        }
        if (!this.isNullEJBLocalObject(context)) {
            context.getEJBLocalObjectImpl().setRemoved(false);
            context.setEJBLocalObjectImpl(null);
        }
    }

    public void clearContext(EJBContextImpl context) {
        context.setEJBLocalObjectImpl(null);
        context.setEJBObjectImpl(null);
        context.setEJBStub(null);
    }
}

